/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.dialogs.EditTransformationVariableDialog;
import com.ibm.cics.cm.ui.editors.CPSMConfigurationOverviewPage;
import com.ibm.cics.cm.ui.editors.CSDConfigurationOverviewPage;
import com.ibm.cics.cm.ui.editors.ConfigurationEditor;
import com.ibm.cics.cm.ui.editors.ConfigurationEditorInput;
import com.ibm.cics.cm.ui.editors.ZfsConfigurationOverviewPage;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.eclipse.common.editor.HelpAction;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ConfigurationOverviewPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAGE_ID = "overviewpage";
    protected FormEditor editor;
    protected Configuration configuration;
    private TableViewer transVarViewer;
    private boolean errorsOnPage = false;
    protected boolean pageLoading = false;
    private Text descText;
    private Button deleteTransVarButton;
    private Button editTransVarButton;

    protected ConfigurationOverviewPage(ConfigurationEditor configurationEditor) {
        super((FormEditor)configurationEditor, PAGE_ID, Messages.getString("ConfigurationOverviewPage.title"));
        this.initialize(configurationEditor);
        this.editor = configurationEditor;
        if (this.editor != null && this.editor.getEditorInput() instanceof ConfigurationEditorInput) {
            this.configuration = ((ConfigurationEditorInput)this.editor.getEditorInput()).getConfiguration();
        }
    }

    public static ConfigurationOverviewPage getConfigurationOverviewPage(ConfigurationEditor editor) {
        if (editor != null && editor.getEditorInput() instanceof ConfigurationEditorInput) {
            Configuration configuration = ((ConfigurationEditorInput)editor.getEditorInput()).getConfiguration();
            if (configuration instanceof CPSMConfiguration) {
                return new CPSMConfigurationOverviewPage(editor);
            }
            if (configuration instanceof CSDConfiguration) {
                return new CSDConfigurationOverviewPage(editor);
            }
            if (configuration instanceof ZfsConfiguration) {
                return new ZfsConfigurationOverviewPage(editor);
            }
        }
        return new ConfigurationOverviewPage(editor);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.pageLoading = true;
        IManagedForm mForm = managedForm;
        FormToolkit toolkit = mForm.getToolkit();
        Form form = mForm.getForm().getForm();
        Composite body = form.getBody();
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        body.setLayout((Layout)layout);
        toolkit.decorateFormHeading(form);
        form.setText(Messages.getString("ConfigurationOverviewPage.title"));
        form.setImage(this.editor.getTitleImage());
        HelpAction helpAction = new HelpAction(this.getHelpContextID());
        form.getToolBarManager().add((IAction)helpAction);
        form.updateToolBar();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, this.getHelpContextID());
        Section genInfoSection = toolkit.createSection(body, 320);
        genInfoSection.setText(Messages.getString("ConfigurationOverviewPage.section.generalinformation.title"));
        genInfoSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite genInfoArea = toolkit.createComposite((Composite)genInfoSection, 0);
        layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        genInfoArea.setLayout((Layout)layout);
        genInfoSection.setClient((Control)genInfoArea);
        genInfoArea.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        Label nameLabel = toolkit.createLabel(genInfoArea, Messages.getString("FIELD.name"));
        nameLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        Label nameValue = toolkit.createLabel(genInfoArea, this.configuration.getName());
        nameValue.setLayoutData((Object)new GridData(16384, -1, false, false));
        Label descLabel = toolkit.createLabel(genInfoArea, Messages.getString("FIELD.description"));
        descLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        TextInput descInput = new TextInput(genInfoArea, descLabel);
        int descBoxWidth = 25;
        int descBoxLimit = 50;
        descInput.setNumberOfCharacters(descBoxWidth);
        this.descText = descInput.text;
        descInput.setLayoutData((Object)new GridData(4, -1, true, false));
        this.descText.setTextLimit(descBoxLimit);
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigurationOverviewPage.this.setDirty(true);
                ConfigurationOverviewPage.this.validateInputs();
            }
        });
        this.createFiletypeSpecificContent(managedForm, toolkit, body);
        Section transVarSection = toolkit.createSection(body, 322);
        transVarSection.setText(Messages.getString("ConfigurationOverviewPage.section.transvar.title"));
        transVarSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite transVarArea = toolkit.createComposite((Composite)transVarSection, 0);
        layout = new GridLayout(2, false);
        transVarArea.setLayout((Layout)layout);
        transVarSection.setClient((Control)transVarArea);
        GridData tableWrapDataTransVar = new GridData(4, 128, true, false, 1, 1);
        transVarArea.setLayoutData((Object)tableWrapDataTransVar);
        this.transVarViewer = this.createTransVarViewer(this.editor, transVarArea);
        this.createTransVarButtonArea(transVarArea, toolkit);
        this.refresh();
        this.pageLoading = false;
    }

    protected void createFiletypeSpecificContent(IManagedForm managedForm, FormToolkit toolkit, Composite body) {
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.editor_configuration";
    }

    private void createTransVarButtonArea(Composite parent, FormToolkit toolkit) {
        Button addButton = new Button(parent, 8);
        addButton.setText(Messages.getString("ConfigurationOverviewPage.button.add"));
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformationVariable newConn;
                Set<String> currentTransVarNames = ConfigurationOverviewPage.this.getTransformationVariables().keySet();
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                EditTransformationVariableDialog dialog = new EditTransformationVariableDialog(parent, currentTransVarNames);
                if (dialog.open() == 0 && (newConn = dialog.getTransformationVariable()) != null) {
                    if (!currentTransVarNames.contains(newConn.getName())) {
                        ConfigurationOverviewPage.this.transVarViewer.add((Object)newConn);
                        ConfigurationOverviewPage.this.setDirty(true);
                    } else {
                        MessageDialog alreadyAdded = new MessageDialog(parent, Messages.getString("transvar.messagebox.alreadyadded.title"), null, Messages.getString("transvar.messagebox.alreadyadded.message"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                        alreadyAdded.open();
                    }
                }
            }
        });
        this.editTransVarButton = new Button(parent, 8);
        this.editTransVarButton.setText(Messages.getString("ConfigurationOverviewPage.button.edit"));
        this.editTransVarButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.editTransVarButton.setEnabled(false);
        this.editTransVarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)ConfigurationOverviewPage.this.transVarViewer.getSelection();
                if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof TransformationVariable) {
                    TransformationVariable newConn;
                    TransformationVariable tv = (TransformationVariable)element;
                    Set<String> currentTransVarNames = ConfigurationOverviewPage.this.getTransformationVariables().keySet();
                    Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    EditTransformationVariableDialog dialog = new EditTransformationVariableDialog(parent, currentTransVarNames, tv);
                    if (dialog.open() == 0 && (newConn = dialog.getTransformationVariable()) != null) {
                        tv.setName(newConn.getName());
                        tv.setValue(newConn.getValue());
                        ConfigurationOverviewPage.this.transVarViewer.update(element, null);
                        ConfigurationOverviewPage.this.setDirty(true);
                    }
                }
            }
        });
        this.deleteTransVarButton = new Button(parent, 8);
        this.deleteTransVarButton.setText(Messages.getString("ConfigurationOverviewPage.button.delete"));
        this.deleteTransVarButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.deleteTransVarButton.setEnabled(false);
        this.deleteTransVarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ConfigurationOverviewPage.this.transVarViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object obj : selection.toList()) {
                        if (!(obj instanceof TransformationVariable)) continue;
                        String tvName = ((TransformationVariable)obj).getName();
                        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        String[] buttons = new String[2];
                        int yesIndex = 0;
                        int noIndex = 1;
                        buttons[yesIndex] = IDialogConstants.YES_LABEL;
                        buttons[noIndex] = IDialogConstants.NO_LABEL;
                        MessageDialog confirmDelete = new MessageDialog(parent, MessageFormat.format(Messages.getString("transvar.messagebox.confirmdelete.title"), tvName), null, MessageFormat.format(Messages.getString("transvar.messagebox.confirmdelete.message"), tvName), 3, buttons, yesIndex);
                        if (confirmDelete.open() != yesIndex) continue;
                        ConfigurationOverviewPage.this.transVarViewer.remove(obj);
                        ConfigurationOverviewPage.this.setDirty(true);
                    }
                }
            }
        });
    }

    private TableViewer createTransVarViewer(FormEditor editor, Composite parent) {
        Table table = new Table(parent, 67584);
        final TableViewer viewer = new TableViewer(table);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(Messages.getString("ConfigurationsOverviewPage.columnHeading.transvar.name"));
        nameColumn.setWidth(120);
        TableColumn valueColumn = new TableColumn(table, 0);
        valueColumn.setText(Messages.getString("ConfigurationsOverviewPage.columnHeading.transvar.value"));
        valueColumn.setWidth(120);
        GridLayout gl = new GridLayout();
        GridData gd = new GridData(4, 128, true, false, 1, 3);
        gd.heightHint = 120;
        table.setLayoutData((Object)gd);
        table.setLayout((Layout)gl);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addTransVarLabelProvider(viewer);
        this.addTransVarContentProvider(viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (viewer.getSelection().isEmpty()) {
                    ConfigurationOverviewPage.this.editTransVarButton.setEnabled(false);
                    ConfigurationOverviewPage.this.deleteTransVarButton.setEnabled(false);
                } else {
                    ConfigurationOverviewPage.this.editTransVarButton.setEnabled(true);
                    ConfigurationOverviewPage.this.deleteTransVarButton.setEnabled(true);
                }
            }
        });
        return viewer;
    }

    private void addTransVarLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                TransformationVariable item = null;
                if (!(element instanceof TransformationVariable)) {
                    return null;
                }
                item = (TransformationVariable)element;
                if (columnIndex == 0) {
                    return item.getName();
                }
                if (columnIndex == 1) {
                    return item.getValue();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void addTransVarContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
    }

    protected boolean hasErrors() {
        return this.errorsOnPage;
    }

    protected String getDescription() {
        return this.descText.getText();
    }

    protected HashMap<String, String> getTransformationVariables() {
        TableItem[] tableItems = this.transVarViewer.getTable().getItems();
        HashMap<String, String> transVars = new HashMap<String, String>();
        int i = 0;
        while (i < tableItems.length) {
            TransformationVariable transVar = (TransformationVariable)tableItems[i].getData();
            if (!transVar.getName().equals("")) {
                transVars.put(transVar.getName().toUpperCase(), transVar.getValue());
            }
            ++i;
        }
        return transVars;
    }

    protected void validateInputs() {
        if (!this.pageLoading) {
            ((ConfigurationEditor)this.editor).refreshDirty();
        }
    }

    protected void setErrorMessage(Control control, String shortMessage, String longMessage) {
        ScrolledForm form = this.getManagedForm().getForm();
        IStatusLineManager status = this.getEditorSite().getActionBars().getStatusLineManager();
        if (control != null) {
            UIHelper.errorControl((Control)control, (String)longMessage);
        }
        form.setMessage(shortMessage, 3);
        status.setErrorMessage(UIActivator.getImage(UIActivator.IMGD_ERROR), longMessage);
        this.errorsOnPage = true;
        status.update(true);
    }

    protected void clearErrorMessage(Control control) {
        ScrolledForm form = this.getManagedForm().getForm();
        IStatusLineManager status = this.getEditorSite().getActionBars().getStatusLineManager();
        if (control != null) {
            UIHelper.clearError((Control)control);
        }
        form.setMessage(null, -1);
        status.setErrorMessage(null);
        this.errorsOnPage = false;
        status.update(true);
    }

    protected void setDirty(boolean value) {
        ((ConfigurationEditor)this.editor).setDirty(value);
    }

    protected void refresh() {
        this.descText.setText(this.configuration.getDescription());
        ArrayList<TransformationVariable> transVarObj = new ArrayList<TransformationVariable>();
        HashMap transVars = this.configuration.getTransformationVariables();
        for (String key : transVars.keySet()) {
            transVarObj.add(new TransformationVariable(key, (String)transVars.get(key)));
        }
        this.transVarViewer.setInput((Object)transVarObj.toArray());
        this.setDirty(false);
    }

    protected void savePage() {
        this.configuration.setDescription(this.getDescription());
        this.saveTypeSpecificAttributes();
        this.configuration.setTransformationVariables(this.getTransformationVariables());
    }

    protected void saveTypeSpecificAttributes() {
    }

    public void setServerError(CMServerException e) {
        String errorMessage = MessageFormat.format(Messages.getString("ConfigurationEditor.errorMessage.genericServer"), e.getMessage());
        this.setErrorMessage(null, errorMessage, errorMessage);
    }
}

