/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.PackageScheme;
import com.ibm.cics.cm.model.PackageSchemeEvent;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.ChangePackageEditor;
import com.ibm.cics.cm.ui.editors.ChangePackageEditorInput;
import com.ibm.cics.cm.ui.views.HistoryView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ChangePackageHistoryPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAGE_ID = "packagehistory";
    private FormEditor editor;
    private TableViewer eventViewer;
    private CheckboxTableViewer pschemeViewer;
    private PackageHistoryContentProvider eventContentProvider;
    private HistoryEventComparator comparator;

    public ChangePackageHistoryPage(ChangePackageEditor changePackageEditor) {
        super(PAGE_ID, Messages.getString("ChangePackageHistoryPage.title"));
        this.initialize(changePackageEditor);
        this.editor = changePackageEditor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        IManagedForm mForm = managedForm;
        FormToolkit toolkit = mForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        body.setLayout((Layout)layout);
        Section schemeSection = toolkit.createSection(body, 450);
        schemeSection.setText(Messages.getString("ChangePackageHistoryPage.section.migrationscheme"));
        schemeSection.setDescription(Messages.getString("ChangePackageHistoryPage.section.migrationscheme.description"));
        schemeSection.setLayoutData((Object)new TableWrapData(256));
        Composite schemeArea = toolkit.createComposite((Composite)schemeSection, 0);
        layout = new TableWrapLayout();
        layout.numColumns = 1;
        schemeArea.setLayout((Layout)layout);
        schemeSection.setClient((Control)schemeArea);
        TableWrapData tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 2;
        schemeArea.setData((Object)tableWrapData);
        this.pschemeViewer = CheckboxTableViewer.newCheckList((Composite)schemeArea, (int)0);
        this.pschemeViewer.setContentProvider((IContentProvider)new PSchemeContentProvider());
        this.pschemeViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (element instanceof PackageScheme) {
                    PackageScheme pscheme = (PackageScheme)element;
                    Map attributes = pscheme.getAttributes();
                    String packageName = (String)attributes.get("CPID");
                    String schemeName = (String)attributes.get("SCHEME");
                    String changeTime = (String)attributes.get("CHANGETIME");
                    return String.valueOf(packageName) + ":" + schemeName + " (" + changeTime + ")";
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.pschemeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] checkedElements = ChangePackageHistoryPage.this.pschemeViewer.getCheckedElements();
                HashSet<PackageScheme> inputSchemes = new HashSet<PackageScheme>();
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object next = objectArray[n2];
                    if (next instanceof PackageScheme) {
                        inputSchemes.add((PackageScheme)next);
                    }
                    ++n2;
                }
                if (ChangePackageHistoryPage.this.eventContentProvider != null) {
                    ChangePackageHistoryPage.this.eventContentProvider.setPSchemes(inputSchemes);
                }
                if (ChangePackageHistoryPage.this.eventViewer != null) {
                    ChangePackageHistoryPage.this.eventViewer.refresh();
                    ChangePackageHistoryPage.this.packColumns(ChangePackageHistoryPage.this.eventViewer.getTable());
                }
            }
        });
        Section historySection = toolkit.createSection(body, 450);
        historySection.setText(Messages.getString("ChangePackageHistoryPage.section.history"));
        historySection.setDescription(Messages.getString("ChangePackageHistoryPage.section.history.description"));
        tableWrapData = new TableWrapData(256, 256);
        tableWrapData.colspan = 1;
        historySection.setLayoutData((Object)tableWrapData);
        Composite historyArea = toolkit.createComposite((Composite)historySection, 0);
        historySection.setClient((Control)historyArea);
        GridLayout gLay = new GridLayout();
        historyArea.setLayout((Layout)gLay);
        this.eventViewer = new TableViewer(historyArea);
        this.eventContentProvider = new PackageHistoryContentProvider();
        this.eventViewer.setContentProvider((IContentProvider)this.eventContentProvider);
        GridData gData = new GridData(1, 1, true, true);
        gData.heightHint = 400;
        this.eventViewer.getTable().setLayoutData((Object)gData);
        this.eventViewer.getTable().setHeaderVisible(true);
        this.comparator = new HistoryEventComparator();
        this.eventViewer.setComparator((ViewerComparator)this.comparator);
        this.eventViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof PackageSchemeEvent) {
                    PackageSchemeEvent psEvent = (PackageSchemeEvent)firstElement;
                    HistoryView historyView = UIActivator.getHistoryView();
                    if (historyView != null) {
                        historyView.setInput((IHistoryProvider)psEvent);
                    }
                }
            }
        });
        this.addColumns(this.eventViewer);
        this.packColumns(this.eventViewer.getTable());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)body, this.getHelpContextID());
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof ChangePackageEditorInput) {
            ChangePackage changePackage = ((ChangePackageEditorInput)input).getChangePackage();
            this.pschemeViewer.setInput((Object)changePackage);
            this.eventViewer.setInput((Object)changePackage);
        }
    }

    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.editor_changepackage";
    }

    private void addColumns(TableViewer table) {
        ColumnLabelProvider labelProv = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PackageSchemeEvent) {
                    return (String)((PackageSchemeEvent)element).getParentScheme().getAttributes().get("SCHEME");
                }
                return "";
            }
        };
        TableViewerColumn column = this.createColumn(table, 0, Messages.getString("ChangePackageHistoryPage.column.scheme"), "CPID", (CellLabelProvider)labelProv, true, true);
        labelProv = new customColumnLabelProvider(PackageSchemeEvent.EventAttribute.CH_APICMD);
        column = this.createColumn(table, 0, Messages.getString("ChangePackageHistoryPage.column.apicommand"), PackageSchemeEvent.EventAttribute.CH_APICMD.toString(), (CellLabelProvider)labelProv, true, true);
        labelProv = new customColumnLabelProvider(PackageSchemeEvent.EventAttribute.CH_DATIME);
        column = this.createColumn(table, 0, Messages.getString("ChangePackageHistoryPage.column.timestamp"), PackageSchemeEvent.EventAttribute.CH_DATIME.toString(), (CellLabelProvider)labelProv, true, true);
        labelProv = new customColumnLabelProvider(PackageSchemeEvent.EventAttribute.CH_USERID);
        column = this.createColumn(table, 0, Messages.getString("ChangePackageHistoryPage.column.userid"), PackageSchemeEvent.EventAttribute.CH_USERID.toString(), (CellLabelProvider)labelProv, true, true);
        labelProv = new customColumnLabelProvider(PackageSchemeEvent.EventAttribute.CH_RC);
        column = this.createColumn(table, 0, Messages.getString("ChangePackageHistoryPage.column.return"), PackageSchemeEvent.EventAttribute.CH_RC.toString(), (CellLabelProvider)labelProv, true, true);
        labelProv = new customColumnLabelProvider(PackageSchemeEvent.EventAttribute.CH_RSN);
        column = this.createColumn(table, 0, Messages.getString("ChangePackageHistoryPage.column.reason"), PackageSchemeEvent.EventAttribute.CH_RSN.toString(), (CellLabelProvider)labelProv, true, true);
        labelProv = new customColumnLabelProvider(PackageSchemeEvent.EventAttribute.CH_EVID);
        column = this.createColumn(table, 0, Messages.getString("ChangePackageHistoryPage.column.eventid"), PackageSchemeEvent.EventAttribute.CH_EVID.toString(), (CellLabelProvider)labelProv, true, true);
    }

    private TableViewerColumn createColumn(TableViewer viewer, int swtFlags, String text, String attribute, CellLabelProvider labelProv, boolean resizable, boolean movable) {
        TableViewerColumn column = new TableViewerColumn(viewer, swtFlags);
        column.getColumn().setResizable(resizable);
        column.getColumn().setMoveable(movable);
        column.getColumn().setText(text);
        column.setLabelProvider(labelProv);
        column.getColumn().addSelectionListener((SelectionListener)this.getSortListener(column, attribute));
        return column;
    }

    private SelectionAdapter getSortListener(final TableViewerColumn column, final String columnID) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangePackageHistoryPage.this.comparator.setColumn(columnID);
                boolean sortAscending = ChangePackageHistoryPage.this.comparator.isSortAscending();
                ChangePackageHistoryPage.this.eventViewer.getTable().setSortColumn(column.getColumn());
                ChangePackageHistoryPage.this.eventViewer.getTable().setSortDirection(sortAscending ? 1024 : 128);
                ChangePackageHistoryPage.this.eventViewer.refresh();
            }
        };
        return listener;
    }

    private void packColumns(final Table table) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!table.isDisposed()) {
                    TableColumn[] tableColumnArray = table.getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn next = tableColumnArray[n2];
                        next.pack();
                        ++n2;
                    }
                    ChangePackageHistoryPage.this.eventViewer.getTable().getParent().layout(true);
                }
            }
        });
    }

    public void refresh() {
        if (this.pschemeViewer != null) {
            this.pschemeViewer.refresh();
        }
        if (this.eventViewer != null) {
            this.eventViewer.refresh();
        }
    }

    private class HistoryEventComparator
    extends ViewerComparator {
        private boolean ascending = true;
        private String columnIndex = PackageSchemeEvent.EventAttribute.CH_DATIME.toString();

        private HistoryEventComparator() {
        }

        public boolean isSortAscending() {
            return this.ascending;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof PackageSchemeEvent & e2 instanceof PackageSchemeEvent) {
                PackageSchemeEvent pse1 = (PackageSchemeEvent)e1;
                PackageSchemeEvent pse2 = (PackageSchemeEvent)e2;
                int result = pse1.getAttribute(this.columnIndex).compareTo(pse2.getAttribute(this.columnIndex));
                return this.ascending ? result : -result;
            }
            return 0;
        }

        public void setColumn(String columnID) {
            if (this.columnIndex.matches(columnID)) {
                this.ascending = !this.ascending;
            } else {
                this.columnIndex = columnID;
                this.ascending = true;
            }
        }
    }

    private class PSchemeContentProvider
    implements IStructuredContentProvider {
        private PSchemeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ChangePackage) {
                IFilteredCollection packageSchemes = ((ChangePackage)inputElement).getPackageSchemes(null);
                return packageSchemes.toArray();
            }
            return new Object[0];
        }
    }

    private class PackageHistoryContentProvider
    implements IStructuredContentProvider {
        Set<PackageScheme> pschemes = new HashSet<PackageScheme>();
        boolean interleaveHistoryItems = true;

        private PackageHistoryContentProvider() {
        }

        public void setPSchemes(Set<PackageScheme> pschemes) {
            if (pschemes != null) {
                this.pschemes = pschemes;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ChangePackage) {
                Comparator<PackageSchemeEvent> comparator = new Comparator<PackageSchemeEvent>(){

                    @Override
                    public int compare(PackageSchemeEvent object1, PackageSchemeEvent object2) {
                        return object2.getAttribute(PackageSchemeEvent.EventAttribute.CH_DATIME).compareTo(object1.getAttribute(PackageSchemeEvent.EventAttribute.CH_DATIME));
                    }
                };
                ArrayList list = new ArrayList();
                for (PackageScheme ps : this.pschemes) {
                    list.addAll(ps.getEvents());
                }
                Collections.sort(list, comparator);
                return list.toArray();
            }
            return new Object[0];
        }
    }

    private class customColumnLabelProvider
    extends ColumnLabelProvider {
        private PackageSchemeEvent.EventAttribute attribute;

        public customColumnLabelProvider(PackageSchemeEvent.EventAttribute attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            PackageSchemeEvent thing;
            String string;
            StringBuffer result = new StringBuffer();
            if (element instanceof PackageSchemeEvent && (string = (thing = (PackageSchemeEvent)element).getAttribute(this.attribute)) != null) {
                result.append(string);
            }
            return result.toString();
        }
    }
}

