/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.CSDConnection;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.dialogs.EditCSDConnectionDialog;
import com.ibm.cics.cm.ui.editors.ConfigurationEditor;
import com.ibm.cics.cm.ui.editors.ConfigurationOverviewPage;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CSDConfigurationOverviewPage
extends ConfigurationOverviewPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TableViewer connsViewer;
    private Text csdFileText;
    private Combo csdRLSCombo;
    private Button audit;
    private Button deleteConnButton;

    protected CSDConfigurationOverviewPage(ConfigurationEditor configurationEditor) {
        super(configurationEditor);
    }

    @Override
    protected void createFiletypeSpecificContent(IManagedForm managedForm, FormToolkit toolkit, Composite body) {
        Section csdOptionsSection = toolkit.createSection(body, 320);
        csdOptionsSection.setText(Messages.getString("ConfigurationOverviewPage.section.csdoptions.title"));
        csdOptionsSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite csdOptionsArea = toolkit.createComposite((Composite)csdOptionsSection, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        csdOptionsArea.setLayout((Layout)layout);
        csdOptionsSection.setClient((Control)csdOptionsArea);
        csdOptionsArea.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        Label csdFileLabel = new Label(csdOptionsArea, 0);
        csdFileLabel.setText(Messages.getString("Configuration.csd.file"));
        csdFileLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        Utilities.addMandatoryField((Control)csdFileLabel);
        TextInput csdFileInput = new TextInput(csdOptionsArea, csdFileLabel);
        int csdBoxLimit = 44;
        csdFileInput.setLayoutData((Object)new GridData(4, -1, true, false));
        this.csdFileText = csdFileInput.text;
        this.csdFileText.setTextLimit(csdBoxLimit);
        this.csdFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSDConfigurationOverviewPage.this.setDirty(true);
                CSDConfigurationOverviewPage.this.validateInputs();
            }
        });
        this.csdFileText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        Label rlsLabel = new Label(csdOptionsArea, 0);
        rlsLabel.setText(Messages.getString("Configuration.csd.rlsaccess"));
        rlsLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        Utilities.addMandatoryField((Control)rlsLabel);
        this.csdRLSCombo = new Combo(csdOptionsArea, 8);
        this.csdRLSCombo.setItems(new String[]{"DYNAMIC", "NOTRLS", "RLS"});
        this.csdRLSCombo.setLayoutData((Object)new GridData(16384, -1, false, false));
        this.csdRLSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSDConfigurationOverviewPage.this.setDirty(true);
                CSDConfigurationOverviewPage.this.validateInputs();
            }
        });
        this.audit = new Button(csdOptionsArea, 32);
        this.audit.setText(Messages.getString("Configuration.csd.audit"));
        this.audit.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        if (CMConnection.apiLevel.compareTo("CCV540") < 0) {
            this.audit.setEnabled(false);
        } else {
            this.audit.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CSDConfigurationOverviewPage.this.setDirty(true);
                    CSDConfigurationOverviewPage.this.validateInputs();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    CSDConfigurationOverviewPage.this.setDirty(true);
                    CSDConfigurationOverviewPage.this.validateInputs();
                }
            });
        }
        Section csdConnSection = toolkit.createSection(body, 322);
        csdConnSection.setText(Messages.getString("ConfigurationOverviewPage.section.connections.title"));
        csdConnSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite csdConnArea = toolkit.createComposite((Composite)csdConnSection, 0);
        layout = new GridLayout(2, false);
        csdConnArea.setLayout((Layout)layout);
        csdConnSection.setClient((Control)csdConnArea);
        csdConnArea.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.createCSDConnectionControls(csdConnArea, toolkit);
    }

    private void createCSDConnectionControls(Composite parent, FormToolkit toolkit) {
        this.connsViewer = this.createConnsViewer(this.editor, parent);
        Button addButton = new Button(parent, 8);
        addButton.setText(Messages.getString("ConfigurationOverviewPage.button.add"));
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newConn;
                ArrayList<String> currentConnectionNames = CSDConfigurationOverviewPage.this.getCSDConnections();
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                EditCSDConnectionDialog dialog = new EditCSDConnectionDialog(parent, currentConnectionNames);
                if (dialog.open() == 0 && (newConn = dialog.getNewConnection()) != null) {
                    if (!currentConnectionNames.contains(newConn)) {
                        CSDConfigurationOverviewPage.this.connsViewer.add((Object)new CSDConnection(newConn));
                        CSDConfigurationOverviewPage.this.setDirty(true);
                    } else {
                        MessageDialog alreadyAdded = new MessageDialog(parent, Messages.getString("csd.messagebox.alreadyadded.title"), null, Messages.getString("csd.messagebox.alreadyadded.message"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                        alreadyAdded.open();
                    }
                }
            }
        });
        this.deleteConnButton = new Button(parent, 8);
        this.deleteConnButton.setText(Messages.getString("ConfigurationOverviewPage.button.delete"));
        this.deleteConnButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.deleteConnButton.setEnabled(false);
        this.deleteConnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CSDConfigurationOverviewPage.this.connsViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object obj : selection.toList()) {
                        if (!(obj instanceof CSDConnection)) continue;
                        String connName = ((CSDConnection)obj).getName();
                        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        String[] buttons = new String[2];
                        int yesIndex = 0;
                        int noIndex = 1;
                        buttons[yesIndex] = IDialogConstants.YES_LABEL;
                        buttons[noIndex] = IDialogConstants.NO_LABEL;
                        MessageDialog confirmDelete = new MessageDialog(parent, MessageFormat.format(Messages.getString("csd.messagebox.confirmdelete.title"), connName), null, MessageFormat.format(Messages.getString("csd.messagebox.confirmdelete.message"), connName), 3, buttons, yesIndex);
                        if (confirmDelete.open() != yesIndex) continue;
                        CSDConfigurationOverviewPage.this.connsViewer.remove(obj);
                        CSDConfigurationOverviewPage.this.setDirty(true);
                    }
                }
            }
        });
    }

    private TableViewer createConnsViewer(FormEditor editor, Composite parent) {
        Table table = new Table(parent, 67586);
        final TableViewer viewer = new TableViewer(table);
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(Messages.getString("ConfigurationsOverviewPage.columnHeading.connection"));
        nameColumn.setWidth(100);
        GridData tableWrapData = new GridData(16384, 128, false, false, 1, 2);
        tableWrapData.heightHint = 120;
        table.setLayoutData((Object)tableWrapData);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        this.addConnsLabelProvider(viewer);
        this.addConnsContentProvider(viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (viewer.getSelection().isEmpty()) {
                    CSDConfigurationOverviewPage.this.deleteConnButton.setEnabled(false);
                } else {
                    CSDConfigurationOverviewPage.this.deleteConnButton.setEnabled(true);
                }
            }
        });
        return viewer;
    }

    private void addConnsLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                CSDConnection item = null;
                if (!(element instanceof CSDConnection)) {
                    return null;
                }
                item = (CSDConnection)element;
                if (columnIndex == 0) {
                    return item.getName();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void addConnsContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
    }

    protected String getCSDFile() {
        return this.csdFileText.getText();
    }

    protected String getCSDRLS() {
        return this.csdRLSCombo.getText();
    }

    protected boolean getCSDAudit() {
        return this.audit.getSelection();
    }

    protected ArrayList<String> getCSDConnections() {
        TableItem[] tableItems = this.connsViewer.getTable().getItems();
        ArrayList<String> connsVars = new ArrayList<String>();
        int i = 0;
        while (i < tableItems.length) {
            CSDConnection connVar = (CSDConnection)tableItems[i].getData();
            if (!connVar.getName().equals("")) {
                connsVars.add(connVar.getName());
            }
            ++i;
        }
        return connsVars;
    }

    @Override
    protected void validateInputs() {
        if (!this.pageLoading) {
            if (this.csdFileText.getText().isEmpty() || !this.csdFileText.getText().matches("[A-Z0-9$@#]{1,8}+(\\.[A-Z0-9$@#]{1,8}){0,43}")) {
                String shortErrorMessage = Messages.getString("ConfigurationWizardDetailsPage.errorMessage.csdName");
                String longErrorMessage = Messages.getString("ConfigurationWizardDetailsPage.errorMessage.csdName");
                this.setErrorMessage((Control)this.csdFileText, shortErrorMessage, longErrorMessage);
            } else {
                this.clearErrorMessage((Control)this.csdFileText);
            }
            ((ConfigurationEditor)this.editor).refreshDirty();
        }
    }

    @Override
    protected void refresh() {
        CSDConfiguration csd = (CSDConfiguration)this.configuration;
        this.csdFileText.setText(csd.getCSDName());
        this.csdRLSCombo.select(this.csdRLSCombo.indexOf((String)csd.getAttributes().get("CSDRLS")));
        this.audit.setSelection(csd.getCSDAudit());
        ArrayList<CSDConnection> connsObj = new ArrayList<CSDConnection>();
        for (String conn : csd.getMROlinks()) {
            connsObj.add(new CSDConnection(conn));
        }
        this.connsViewer.setInput((Object)connsObj.toArray());
        super.refresh();
    }

    @Override
    protected void saveTypeSpecificAttributes() {
        CSDConfiguration csd = (CSDConfiguration)this.configuration;
        csd.setCSDFile(this.getCSDFile());
        csd.setCSDRLS(this.getCSDRLS());
        if (CMConnection.apiLevel.compareTo("CCV540") >= 0) {
            csd.setCSDAudit(this.getCSDAudit());
        }
        csd.setMROLinks(this.getCSDConnections());
    }
}

