/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.editors.ConfigurationEditor;
import com.ibm.cics.cm.ui.editors.ConfigurationOverviewPage;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.eclipse.common.ui.TextInput;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CPSMConfigurationOverviewPage
extends ConfigurationOverviewPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text contextText;

    protected CPSMConfigurationOverviewPage(ConfigurationEditor configurationEditor) {
        super(configurationEditor);
    }

    @Override
    protected void createFiletypeSpecificContent(IManagedForm managedForm, FormToolkit toolkit, Composite body) {
        Section cpsmOptionsSection = toolkit.createSection(body, 320);
        cpsmOptionsSection.setText(Messages.getString("ConfigurationOverviewPage.section.cpsmoptions.title"));
        cpsmOptionsSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite cpsmOptionsArea = toolkit.createComposite((Composite)cpsmOptionsSection, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        cpsmOptionsArea.setLayout((Layout)layout);
        cpsmOptionsSection.setClient((Control)cpsmOptionsArea);
        cpsmOptionsArea.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        Label contextLabel = new Label(cpsmOptionsArea, 0);
        contextLabel.setText(Messages.getString("Configuration.cpsm.context"));
        contextLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        Utilities.addMandatoryField((Control)contextLabel);
        TextInput contextInput = new TextInput(cpsmOptionsArea, contextLabel);
        int contextBoxLimit = 8;
        contextInput.setNumberOfCharacters(contextBoxLimit);
        this.contextText = contextInput.text;
        this.contextText.setLayoutData((Object)new GridData(16384, -1, false, false));
        this.contextText.setTextLimit(contextBoxLimit);
        this.contextText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CPSMConfigurationOverviewPage.this.setDirty(true);
                CPSMConfigurationOverviewPage.this.validateInputs();
            }
        });
        this.contextText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
    }

    @Override
    protected void validateInputs() {
        if (!this.pageLoading) {
            if (this.contextText.getText().isEmpty() || !this.contextText.getText().matches("[A-Z0-9$@#]{1,8}")) {
                String shortErrorMessage = Messages.getString("ConfigurationWizardDetailsPage.errorMessage.cpsmName");
                String longErrorMessage = Messages.getString("ConfigurationWizardDetailsPage.errorMessage.cpsmName");
                this.setErrorMessage((Control)this.contextText, shortErrorMessage, longErrorMessage);
            } else {
                this.clearErrorMessage((Control)this.contextText);
            }
            ((ConfigurationEditor)this.editor).refreshDirty();
        }
    }

    protected String getCPSMContext() {
        return this.contextText.getText();
    }

    @Override
    protected void refresh() {
        this.contextText.setText(((CPSMConfiguration)this.configuration).getCPSMContext());
        super.refresh();
    }

    @Override
    public void saveTypeSpecificAttributes() {
        CPSMConfiguration cpsm = (CPSMConfiguration)this.configuration;
        cpsm.setCPSMContext(this.getCPSMContext());
    }
}

