/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.dialogs;

import com.ibm.cics.cm.model.CMSystemOptions;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SystemOptionsDialog
extends TitleAreaDialog
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Logger logger = Logger.getLogger(SystemOptionsDialog.class.getPackage().getName());
    private CMSystemOptions cmSysOpt = null;
    private boolean pageLoading = false;
    private Button approvalsForCP;
    private Button automaticCPNumbering;
    private Button tranProcessingForResMigrations;
    private Button autoRemoveOfDelGroups;
    private Button exitPointProcessingOnServer;
    private Button secCheckForAPICommands;
    private Text apiSAFClassText;
    private Text apiSAFPrefixText;
    private Button secCheckByCICSResKeys;
    private Text resKeysSAFClassText;
    private Text resKeysSAFPrefixText;

    public SystemOptionsDialog(Shell parentShell) {
        super(parentShell);
        this.setTitleImage(UIActivator.IMGD_SYSTEM_OPTIONS_WIZ.createImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.pageLoading = true;
        Composite clientArea = new Composite(parent, 0);
        clientArea.setLayout((Layout)new GridLayout(1, false));
        clientArea.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite generalArea = new Composite(clientArea, 0);
        generalArea.setLayout((Layout)new GridLayout(2, false));
        generalArea.setLayoutData((Object)new GridData(4, 0, true, false));
        if (ConfigurationManager.getCurrent().getConnection() == null || !ConfigurationManager.getCurrent().getConnection().isConnected()) {
            this.createErrorComposite(clientArea, com.ibm.cics.cm.cpsm.comm.Messages.getString((String)"CMSMConnection.0"));
        } else {
            this.cmSysOpt = ConfigurationManager.getCurrent().getSystemOptions(true);
            if (this.cmSysOpt == null) {
                this.createErrorComposite(clientArea, Messages.getString("SystemOptionsDialog.UnableToRetrieve"));
            } else {
                Label l = new Label(generalArea, 16384);
                l.setText(Messages.getString("SystemOptionsDialog.General"));
                GridData data = new GridData(4, 0, true, false);
                l.setLayoutData((Object)data);
                this.createOptionsComposite(clientArea, this.cmSysOpt);
                this.createSecurityControlsComposite(clientArea, this.cmSysOpt);
                this.performDefaults();
            }
        }
        this.pageLoading = false;
        this.getShell().setText(Messages.getString("SystemOptionsDialog.dialog.title"));
        this.setTitle(Messages.getString("SystemOptionsDialog.dialog.title"));
        this.setMessage(Messages.getString("SystemOptionsDialog.dialog.message"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), this.getHelpContextID());
        return clientArea;
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.dialog_system_options";
    }

    private Composite createErrorComposite(Composite parent, String errorMessage) {
        Composite noConnectionArea = new Composite(parent, 0);
        noConnectionArea.setLayout((Layout)new GridLayout(1, false));
        noConnectionArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label noConnectionLabel = new Label(noConnectionArea, 0x1000000);
        noConnectionLabel.setText(errorMessage);
        GridData data = new GridData(0x1000000, 0x1000000, true, true);
        noConnectionLabel.setLayoutData((Object)data);
        return noConnectionArea;
    }

    private Composite createOptionsComposite(Composite parent, CMSystemOptions cmSysOpt) {
        Composite optionsArea = new Composite(parent, 0);
        optionsArea.setLayout((Layout)new GridLayout(1, false));
        optionsArea.setLayoutData((Object)new GridData(4, 0, true, false));
        Label optionsLabel = new Label(optionsArea, 16384);
        optionsLabel.setText(Messages.getString("SystemOptionsDialog.Options"));
        GridData data = new GridData(4, 0, true, false);
        optionsLabel.setLayoutData((Object)data);
        data = new GridData(4, 0, true, false);
        data.horizontalIndent = 10;
        this.approvalsForCP = new Button(optionsArea, 32);
        this.approvalsForCP.setText(Messages.getString("SystemOptionsDialog.ApprovalsForCP"));
        this.approvalsForCP.setLayoutData((Object)data);
        this.automaticCPNumbering = new Button(optionsArea, 32);
        this.automaticCPNumbering.setText(Messages.getString("SystemOptionsDialog.AutoCPNumbering"));
        this.automaticCPNumbering.setLayoutData((Object)data);
        this.tranProcessingForResMigrations = new Button(optionsArea, 32);
        this.tranProcessingForResMigrations.setText(Messages.getString("SystemOptionsDialog.TranProcessingForResMigrations"));
        this.tranProcessingForResMigrations.setLayoutData((Object)data);
        this.autoRemoveOfDelGroups = new Button(optionsArea, 32);
        this.autoRemoveOfDelGroups.setText(Messages.getString("SystemOptionsDialog.AutoRemoveOfDelGroups"));
        this.autoRemoveOfDelGroups.setLayoutData((Object)data);
        this.exitPointProcessingOnServer = new Button(optionsArea, 32);
        this.exitPointProcessingOnServer.setText(Messages.getString("SystemOptionsDialog.ExitPointProcessingOnServer"));
        this.exitPointProcessingOnServer.setLayoutData((Object)data);
        return optionsArea;
    }

    private Composite createSecurityControlsComposite(Composite parent, CMSystemOptions cmSysOpt) {
        Composite securityControlsArea = new Composite(parent, 0);
        securityControlsArea.setLayout((Layout)new GridLayout(1, false));
        securityControlsArea.setLayoutData((Object)new GridData(4, 0, true, false));
        int safClassLength = 8;
        int safPrefixLength = 8;
        GridData labelGD = new GridData(-1, -1, false, false);
        labelGD.horizontalIndent = 30;
        GridData textGD = new GridData(-1, -1, false, false);
        GridLayout gl = new GridLayout(2, false);
        gl.marginRight = 0;
        gl.marginBottom = 0;
        gl.marginTop = 0;
        gl.marginLeft = 0;
        Label securityControlsLabel = new Label(securityControlsArea, 16384);
        securityControlsLabel.setText(Messages.getString("SystemOptionsDialog.SecurityControls"));
        GridData data = new GridData(4, 0, true, false);
        securityControlsLabel.setLayoutData((Object)data);
        data = new GridData(4, 0, true, false);
        Composite secCheckForAPICommandsArea = new Composite(securityControlsArea, 0);
        secCheckForAPICommandsArea.setLayout((Layout)gl);
        secCheckForAPICommandsArea.setLayoutData((Object)new GridData(4, 0, true, false));
        this.secCheckForAPICommands = new Button(secCheckForAPICommandsArea, 32);
        this.secCheckForAPICommands.setText(Messages.getString("SystemOptionsDialog.SecCheckForAPICommands"));
        GridData data2 = new GridData(4, 0, true, false);
        data2.horizontalIndent = 5;
        data2.horizontalSpan = 2;
        this.secCheckForAPICommands.setLayoutData((Object)data2);
        Label apiSAFClassLabel = new Label(secCheckForAPICommandsArea, 16384);
        apiSAFClassLabel.setText(Messages.getString("SystemOptionsDialog.SAFResourceClass"));
        apiSAFClassLabel.setLayoutData((Object)labelGD);
        TextInput apiSAFClassInput = new TextInput(secCheckForAPICommandsArea, apiSAFClassLabel.getText());
        this.apiSAFClassText = apiSAFClassInput.text;
        this.apiSAFClassText.setTextLimit(safClassLength);
        this.apiSAFClassText.setLayoutData((Object)textGD);
        this.apiSAFClassText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.apiSAFClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemOptionsDialog.this.validateInputs();
            }
        });
        Label apiSAFPrefixLabel = new Label(secCheckForAPICommandsArea, 16384);
        apiSAFPrefixLabel.setText(Messages.getString("SystemOptionsDialog.SecurityKeyPrefix"));
        apiSAFPrefixLabel.setLayoutData((Object)labelGD);
        TextInput apiSAFPrefixInput = new TextInput(secCheckForAPICommandsArea, apiSAFPrefixLabel.getText());
        this.apiSAFPrefixText = apiSAFPrefixInput.text;
        this.apiSAFPrefixText.setTextLimit(safPrefixLength);
        this.apiSAFPrefixText.setLayoutData((Object)textGD);
        this.apiSAFPrefixText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.apiSAFPrefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemOptionsDialog.this.validateInputs();
            }
        });
        Composite secCheckByCICSResKeysArea = new Composite(securityControlsArea, 0);
        secCheckByCICSResKeysArea.setLayout((Layout)gl);
        secCheckByCICSResKeysArea.setLayoutData((Object)new GridData(4, 0, true, false));
        this.secCheckByCICSResKeys = new Button(secCheckByCICSResKeysArea, 32);
        this.secCheckByCICSResKeys.setText(Messages.getString("SystemOptionsDialog.SecCheckByCICSResKeys"));
        GridData data3 = new GridData(4, 0, true, false);
        data3.horizontalIndent = 5;
        data3.horizontalSpan = 2;
        this.secCheckByCICSResKeys.setLayoutData((Object)data3);
        Label resKeysSAFClassLabel = new Label(secCheckByCICSResKeysArea, 16384);
        resKeysSAFClassLabel.setText(Messages.getString("SystemOptionsDialog.SAFResourceClass"));
        resKeysSAFClassLabel.setLayoutData((Object)labelGD);
        TextInput resKeysSAFClassInput = new TextInput(secCheckByCICSResKeysArea, resKeysSAFClassLabel.getText());
        this.resKeysSAFClassText = resKeysSAFClassInput.text;
        this.resKeysSAFClassText.setTextLimit(safClassLength);
        this.resKeysSAFClassText.setLayoutData((Object)textGD);
        this.resKeysSAFClassText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.resKeysSAFClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemOptionsDialog.this.validateInputs();
            }
        });
        Label resKeysSAFPrefixLabel = new Label(secCheckByCICSResKeysArea, 16384);
        resKeysSAFPrefixLabel.setText(Messages.getString("SystemOptionsDialog.SecurityKeyPrefix"));
        resKeysSAFPrefixLabel.setLayoutData((Object)labelGD);
        TextInput resKeysSAFPrefixInput = new TextInput(secCheckByCICSResKeysArea, resKeysSAFPrefixLabel.getText());
        this.resKeysSAFPrefixText = resKeysSAFPrefixInput.text;
        this.resKeysSAFPrefixText.setTextLimit(safPrefixLength);
        this.resKeysSAFPrefixText.setLayoutData((Object)textGD);
        this.resKeysSAFPrefixText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.resKeysSAFPrefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemOptionsDialog.this.validateInputs();
            }
        });
        return securityControlsArea;
    }

    private boolean yesNoToBoolean(String yesNo) {
        return yesNo.trim().equalsIgnoreCase("YES");
    }

    private void validateInputs() {
        if (!this.pageLoading) {
            if (this.apiSAFClassText == null || !this.apiSAFClassText.getText().matches("[A-Z0-9$@#]{1,8}")) {
                this.setErrorMessage(Messages.getString("SystemOptionsDialog.error.SAFResouceClass.short"));
                UIHelper.errorControl((Control)this.apiSAFClassText, (String)Messages.getString("SystemOptionsDialog.error.SAFResouceClass"));
            } else {
                UIHelper.clearError((Control)this.apiSAFClassText);
                if (this.apiSAFPrefixText == null || !this.apiSAFPrefixText.getText().matches("[A-Z0-9$@#]{1,8}")) {
                    this.setErrorMessage(Messages.getString("SystemOptionsDialog.error.SecurityKeyPrefix.short"));
                    UIHelper.errorControl((Control)this.apiSAFPrefixText, (String)Messages.getString("SystemOptionsDialog.error.SecurityKeyPrefix"));
                } else {
                    UIHelper.clearError((Control)this.apiSAFPrefixText);
                    if (this.resKeysSAFClassText == null || !this.resKeysSAFClassText.getText().matches("[A-Z0-9$@#]{1,8}")) {
                        this.setErrorMessage(Messages.getString("SystemOptionsDialog.error.SAFResouceClass.short"));
                        UIHelper.errorControl((Control)this.resKeysSAFClassText, (String)Messages.getString("SystemOptionsDialog.error.SAFResouceClass"));
                    } else {
                        UIHelper.clearError((Control)this.resKeysSAFClassText);
                        if (this.resKeysSAFPrefixText == null || !this.resKeysSAFPrefixText.getText().matches("[A-Z0-9$@#]{1,8}")) {
                            this.setErrorMessage(Messages.getString("SystemOptionsDialog.error.SecurityKeyPrefix.short"));
                            UIHelper.errorControl((Control)this.resKeysSAFPrefixText, (String)Messages.getString("SystemOptionsDialog.error.SecurityKeyPrefix"));
                        } else {
                            UIHelper.clearError((Control)this.resKeysSAFPrefixText);
                            this.setErrorMessage(null);
                        }
                    }
                }
            }
        }
    }

    protected void performDefaults() {
        if (this.approvalsForCP != null) {
            this.approvalsForCP.setSelection(this.yesNoToBoolean(this.cmSysOpt.getAttribute("PKGAPPACT")));
        }
        if (this.automaticCPNumbering != null) {
            this.automaticCPNumbering.setSelection(this.yesNoToBoolean(this.cmSysOpt.getAttribute("PKGAUTNUM")));
        }
        if (this.tranProcessingForResMigrations != null) {
            this.tranProcessingForResMigrations.setSelection(this.yesNoToBoolean(this.cmSysOpt.getAttribute("XFORMACT")));
        }
        if (this.autoRemoveOfDelGroups != null) {
            this.autoRemoveOfDelGroups.setSelection(this.yesNoToBoolean(this.cmSysOpt.getAttribute("AUTOGRPREM")));
        }
        if (this.exitPointProcessingOnServer != null) {
            this.exitPointProcessingOnServer.setSelection(this.yesNoToBoolean(this.cmSysOpt.getAttribute("EXITSACT")));
        }
        if (this.secCheckForAPICommands != null) {
            this.secCheckForAPICommands.setSelection(this.yesNoToBoolean(this.cmSysOpt.getAttribute("SECCHKACT")));
        }
        if (this.apiSAFClassText != null) {
            this.apiSAFClassText.setText(this.cmSysOpt.getAttribute("SAFCLASS"));
        }
        if (this.apiSAFPrefixText != null) {
            this.apiSAFPrefixText.setText(this.cmSysOpt.getAttribute("SAFPREFIX"));
        }
        if (this.secCheckByCICSResKeys != null) {
            this.secCheckByCICSResKeys.setSelection(this.yesNoToBoolean(this.cmSysOpt.getAttribute("SEC02ACT")));
        }
        if (this.resKeysSAFClassText != null) {
            this.resKeysSAFClassText.setText(this.cmSysOpt.getAttribute("SEC02_SAFCLASS"));
        }
        if (this.resKeysSAFPrefixText != null) {
            this.resKeysSAFPrefixText.setText(this.cmSysOpt.getAttribute("SEC02_SAFPREFIX"));
        }
        this.validateInputs();
    }

    protected void okPressed() {
        if (this.getErrorMessage() == null || this.getErrorMessage().isEmpty()) {
            HashMap attr = (HashMap)this.cmSysOpt.getAttributes();
            if (this.approvalsForCP != null) {
                attr.put("PKGAPPACT", this.approvalsForCP.getSelection() ? "YES" : "NO");
            }
            if (this.automaticCPNumbering != null) {
                attr.put("PKGAUTNUM", this.automaticCPNumbering.getSelection() ? "YES" : "NO");
            }
            if (this.tranProcessingForResMigrations != null) {
                attr.put("XFORMACT", this.tranProcessingForResMigrations.getSelection() ? "YES" : "NO");
            }
            if (this.autoRemoveOfDelGroups != null) {
                attr.put("AUTOGRPREM", this.autoRemoveOfDelGroups.getSelection() ? "YES" : "NO");
            }
            if (this.exitPointProcessingOnServer != null) {
                attr.put("EXITSACT", this.exitPointProcessingOnServer.getSelection() ? "YES" : "NO");
            }
            if (this.secCheckForAPICommands != null) {
                attr.put("SECCHKACT", this.secCheckForAPICommands.getSelection() ? "YES" : "NO");
            }
            if (this.apiSAFClassText != null) {
                attr.put("SAFCLASS", this.apiSAFClassText.getText());
            }
            if (this.apiSAFPrefixText != null) {
                attr.put("SAFPREFIX", this.apiSAFPrefixText.getText());
            }
            if (this.secCheckByCICSResKeys != null) {
                attr.put("SEC02ACT", this.secCheckByCICSResKeys.getSelection() ? "YES" : "NO");
            }
            if (this.resKeysSAFClassText != null) {
                attr.put("SEC02_SAFCLASS", this.resKeysSAFClassText.getText());
            }
            if (this.resKeysSAFPrefixText != null) {
                attr.put("SEC02_SAFPREFIX", this.resKeysSAFPrefixText.getText());
            }
            this.cmSysOpt.update();
        }
        super.okPressed();
    }
}

