/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.dialogs;

import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.utilities.CSDConnectionContentProposalProvider;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.core.ui.editors.wizards.LazyContentAssistCommandAdapter;
import com.ibm.cics.core.ui.editors.wizards.SearchText;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditCSDConnectionDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String HAS_CONTENT_ASSIST = "HAS_CONTENT_ASSIST";
    private Text connectionText;
    private SearchText repositorySearchText;
    private Button addButton;
    private String connectionName;
    private List<String> excludeConnections;

    public EditCSDConnectionDialog(Shell parentShell, List<String> excludeConnections) {
        super(parentShell);
        this.excludeConnections = excludeConnections;
    }

    protected Control createDialogArea(final Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        childArea.setLayout((Layout)gridLayout);
        TextInput connectionTextInput = new TextInput(childArea, Messages.getString("csd.contextsearch.hint"));
        connectionTextInput.setNumberOfCharacters(4);
        connectionTextInput.setLayoutData((Object)new GridData(4, 128, true, false));
        this.connectionText = connectionTextInput.text;
        this.connectionText.setTextLimit(4);
        this.connectionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EditCSDConnectionDialog.this.connectionText.getText() != null && !EditCSDConnectionDialog.this.connectionText.getText().trim().isEmpty() && EditCSDConnectionDialog.this.addButton != null && EditCSDConnectionDialog.this.connectionText.getText().matches("[A-Z0-9]{1,4}")) {
                    EditCSDConnectionDialog.this.connectionName = EditCSDConnectionDialog.this.connectionText.getText().trim();
                    EditCSDConnectionDialog.this.setErrorMessage(null);
                    UIHelper.clearError((Control)EditCSDConnectionDialog.this.connectionText);
                    EditCSDConnectionDialog.this.addButton.setEnabled(true);
                } else if (EditCSDConnectionDialog.this.addButton != null) {
                    EditCSDConnectionDialog.this.setErrorMessage(Messages.getString("csd.errormessage.format"));
                    UIHelper.errorControl((Control)EditCSDConnectionDialog.this.connectionText, (String)Messages.getString("csd.errormessage.format"));
                    EditCSDConnectionDialog.this.addButton.setEnabled(false);
                }
            }
        });
        this.connectionText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        CSDConnectionContentProposalProvider contentProposalProvider = new CSDConnectionContentProposalProvider(this.excludeConnections);
        TextContentAdapter textContentAdapter = new TextContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                super.insertControlContents(control, text, cursorPosition);
                EditCSDConnectionDialog.this.repositorySearchText.cancel();
            }
        };
        LabelProvider connectionLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((IContentProposal)element).getLabel();
            }
        };
        final LazyContentAssistCommandAdapter contentProposalAdapter = new LazyContentAssistCommandAdapter((Control)this.connectionText, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)contentProposalProvider, null, null, true);
        contentProposalAdapter.setProposalAcceptanceStyle(2);
        contentProposalProvider.addListener(new CSDConnectionContentProposalProvider.Listener(){

            @Override
            public void dataAvailable() {
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        contentProposalAdapter.updatePopupContents();
                    }
                });
            }
        });
        contentProposalAdapter.setEnabled(true);
        contentProposalAdapter.setLabelProvider((ILabelProvider)connectionLabelProvider);
        this.connectionText.setData(HAS_CONTENT_ASSIST, (Object)Boolean.TRUE);
        this.setTitle(Messages.getString("csd.dialog.title"));
        this.getShell().setText(Messages.getString("csd.dialog.title"));
        this.setTitleImage(UIActivator.getImage(UIActivator.IMGD_CSD_CONN_WIZ));
        this.setMessage(Messages.getString("csd.dialog.description"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.cm.ui.dialog_addconnections");
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.addButton = this.createButton(parent, 0, Messages.getString("csd.dialog.button.add"), true);
        this.addButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public String getNewConnection() {
        if (this.connectionName != null) {
            return this.connectionName;
        }
        return null;
    }
}

