/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.dialogs;

import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.zfs.ZfsNode;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class BrowseZfsDialog
extends SelectionStatusDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected TreeViewer viewer;
    private final String rootPath;
    private final String configName;
    private final String messageIdentifier;
    private final boolean directoryOnly;
    private Label statusImage;
    private Label statusMessage;

    public BrowseZfsDialog(Shell parentShell, ZfsConfiguration config, String messageIdentifier) {
        super(parentShell);
        if (config == null) {
            this.rootPath = "/";
            this.configName = "(ROOT)";
            this.directoryOnly = true;
        } else {
            String rootPath = config.getZfsRootDir();
            this.rootPath = rootPath.substring(0, rootPath.length() - 1);
            this.configName = config.getName();
            this.directoryOnly = false;
        }
        this.messageIdentifier = messageIdentifier;
        this.setTitle(Messages.getString("BrowseZfs.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label label = new Label(dialogArea, 64);
        label.setText(Messages.getString("BrowseZfs." + this.messageIdentifier + ".instructions"));
        label.setFont(dialogArea.getFont());
        GridData labelGridData = new GridData(4, 0x1000000, true, false);
        labelGridData.widthHint = 300;
        label.setLayoutData((Object)labelGridData);
        Tree tree = new Tree(dialogArea, 268437508);
        GridData treeLayout = new GridData(4, 4, true, true);
        treeLayout.heightHint = 300;
        treeLayout.widthHint = 300;
        tree.setLayoutData((Object)treeLayout);
        this.viewer = new TreeViewer(tree);
        this.viewer.setUseHashlookup(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ZfsLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ZfsContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BrowseZfsDialog.this.computeResult();
            }
        });
        this.viewer.setInput((Object)new ZfsNode(this.viewer, this.rootPath, this.configName, this.directoryOnly));
        Composite statusMessageArea = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout(2, false);
        statusMessageArea.setLayout((Layout)layout);
        statusMessageArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.statusImage = new Label(statusMessageArea, 0);
        this.statusImage.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.statusMessage = new Label(statusMessageArea, 64);
        this.statusMessage.setFont(dialogArea.getFont());
        labelGridData = new GridData(4, 0x1000000, true, false);
        labelGridData.widthHint = 300;
        this.statusMessage.setLayoutData((Object)labelGridData);
        return dialogArea;
    }

    public String getSelectedPath() {
        Object[] result = this.getResult();
        if (result != null && result.length > 0 && result[0] instanceof ZfsNode) {
            return ((ZfsNode)result[0]).getFullPath();
        }
        return "";
    }

    protected void computeResult() {
        boolean ok = false;
        String message = "";
        this.setResult(this.viewer.getStructuredSelection().toList());
        Object[] selection = this.getResult();
        if (selection != null && selection.length > 0 && selection[0] instanceof ZfsNode && ((ZfsNode)selection[0]).isReal()) {
            if (((ZfsNode)selection[0]).getFullPath().length() > 255) {
                message = Messages.getString("BrowseZfs." + this.messageIdentifier + ".tooLong");
            } else if (((ZfsNode)selection[0]).isSelectable()) {
                ok = true;
            }
        }
        this.statusMessage.setText(message);
        this.statusImage.setImage("".equals(message) ? null : ImageFactory.getErrorImage());
        this.statusMessage.getParent().pack(true);
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(ok);
        }
    }

    private class ZfsContentProvider
    implements ILazyTreeContentProvider {
        private ZfsContentProvider() {
        }

        public Object getParent(Object element) {
            if (element instanceof ZfsNode) {
                return ((ZfsNode)element).getParent();
            }
            return null;
        }

        public void updateElement(Object parent, int index) {
            List<ZfsNode> children;
            if (parent instanceof ZfsNode && index < (children = ((ZfsNode)parent).getChildren()).size()) {
                ZfsNode child = children.get(index);
                BrowseZfsDialog.this.viewer.replace(parent, index, (Object)child);
                BrowseZfsDialog.this.viewer.setChildCount((Object)child, child.getChildCount());
            }
        }

        public void updateChildCount(Object element, int currentChildCount) {
            int size;
            if (element instanceof ZfsNode && (size = ((ZfsNode)element).getChildCount()) != currentChildCount) {
                BrowseZfsDialog.this.viewer.setChildCount(element, size);
            }
        }
    }

    private class ZfsLabelProvider
    implements ILabelProvider {
        private ZfsLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof ZfsNode) {
                return ((ZfsNode)element).getImage();
            }
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

