/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.dialogs;

import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddTransformationVariableDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Button addButton;
    protected String name;
    protected String source;
    protected String target;
    private ArrayList<TransformationVariable> vars;

    public AddTransformationVariableDialog(Shell parentShell, ArrayList<TransformationVariable> vars) {
        super(parentShell);
        this.vars = vars;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(4, 4, true, true);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 10;
        childArea.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(childArea, 0);
        nameLabel.setText(Messages.getString("MigrationSchemeEditor.XVar.field.name"));
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Utilities.addMandatoryField((Control)nameLabel);
        TextInput nameInput = new TextInput(childArea, nameLabel);
        int nameBoxLimit = 16;
        nameInput.setNumberOfCharacters(nameBoxLimit);
        final Text nameText = nameInput.text;
        nameText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        nameText.setTextLimit(nameBoxLimit);
        nameText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddTransformationVariableDialog.this.name = nameText.getText();
                AddTransformationVariableDialog.this.checkButtons();
            }
        });
        Label sourceLabel = new Label(childArea, 0);
        sourceLabel.setText(Messages.getString("MigrationSchemeEditor.XVar.field.source"));
        sourceLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        TextInput sourceInput = new TextInput(childArea, nameLabel);
        int sourceLimit = 30;
        sourceInput.setNumberOfCharacters(sourceLimit);
        final Text sourceText = sourceInput.text;
        sourceText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        sourceText.setTextLimit(sourceLimit);
        sourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddTransformationVariableDialog.this.source = sourceText.getText();
                AddTransformationVariableDialog.this.checkButtons();
            }
        });
        Label targetLabel = new Label(childArea, 0);
        targetLabel.setText(Messages.getString("MigrationSchemeEditor.XVar.field.target"));
        targetLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        TextInput targetInput = new TextInput(childArea, nameLabel);
        int targetLimit = 30;
        targetInput.setNumberOfCharacters(targetLimit);
        final Text targetText = targetInput.text;
        targetText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        targetText.setTextLimit(targetLimit);
        targetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddTransformationVariableDialog.this.target = targetText.getText();
                AddTransformationVariableDialog.this.checkButtons();
            }
        });
        this.checkButtons();
        this.setTitle(Messages.getString("transvar.dialog.add.title"));
        this.getShell().setText(Messages.getString("transvar.dialog.add.title"));
        this.setTitleImage(UIActivator.getImage(UIActivator.IMGD520_MIGRATION_SCHEME_NEW_WIZARD));
        this.setMessage(Messages.getString("transvar.dialog.description.scheme"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.cm.ui.dialog_addtransvar_scheme");
        return c;
    }

    private void checkButtons() {
        if (this.addButton != null) {
            if (this.name != null && !this.name.isEmpty()) {
                this.setErrorMessage(null);
                for (TransformationVariable var : this.vars) {
                    if (!var.getName().equals(this.name)) continue;
                    this.setErrorMessage(Messages.getString("transvar.validate.already.scheme"));
                    break;
                }
                this.addButton.setEnabled(this.getErrorMessage() == null);
            } else {
                this.addButton.setEnabled(false);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.addButton = this.createButton(parent, 0, Messages.getString("csd.dialog.button.add"), true);
        this.addButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.checkButtons();
    }

    public TransformationVariable getTransformationVariable() {
        return new TransformationVariable(this.name, this.source, this.target);
    }
}

