/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.dialogs;

import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.MigrationPath;
import com.ibm.cics.cm.model.TransformationRuleSet;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.utilities.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddMigrationPathDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NO_CONFIGURATIONS = Messages.getString("MigrationPath.dialog.no_configurations");
    private static final String NO_RULE = Messages.getString("MigrationPath.dialog.no_rule");
    private Button addButton;
    protected String source;
    protected String target;
    protected String rule;
    protected boolean das;
    private Combo sourceCombo;
    private Combo targetCombo;
    private Combo ruleCombo;
    private Button deleteAtSource;
    ArrayList<MigrationPath> paths;

    public AddMigrationPathDialog(Shell parentShell, ArrayList<MigrationPath> paths) {
        super(parentShell);
        this.paths = paths;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(4, 4, true, true);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        gridLayout.verticalSpacing = 15;
        childArea.setLayout((Layout)gridLayout);
        Label newSourceLabel = new Label(childArea, 0);
        newSourceLabel.setText(Messages.getString("MigrationPath.dialog.source"));
        newSourceLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Utilities.addMandatoryField((Control)newSourceLabel);
        this.sourceCombo = this.createConfigurationSelectionCombo(childArea);
        this.sourceCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sourceCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddMigrationPathDialog.this.source = AddMigrationPathDialog.this.sourceCombo.getItem(AddMigrationPathDialog.this.sourceCombo.getSelectionIndex());
                AddMigrationPathDialog.this.checkButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.sourceCombo.select(0);
        this.source = this.sourceCombo.getItem(0);
        Label newTargetLabel = new Label(childArea, 0);
        newTargetLabel.setText(Messages.getString("MigrationPath.dialog.target"));
        newTargetLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Utilities.addMandatoryField((Control)newTargetLabel);
        this.targetCombo = this.createConfigurationSelectionCombo(childArea);
        this.targetCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.targetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddMigrationPathDialog.this.target = AddMigrationPathDialog.this.targetCombo.getItem(AddMigrationPathDialog.this.targetCombo.getSelectionIndex());
                AddMigrationPathDialog.this.checkButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.targetCombo.getItemCount() < 2) {
            this.targetCombo.select(0);
        } else {
            this.targetCombo.select(1);
        }
        this.target = this.targetCombo.getItem(this.targetCombo.getSelectionIndex());
        Label newRuleLabel = new Label(childArea, 0);
        newRuleLabel.setText(Messages.getString("MigrationPath.dialog.rule"));
        newRuleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.ruleCombo = new Combo(childArea, 8);
        IFilteredCollection transformationRuleSets = ConfigurationManager.getCurrent().getTransformationRuleSets();
        this.ruleCombo.add(NO_RULE);
        List xRules = transformationRuleSets.getResults();
        Collections.sort(xRules, new TransformationRuleSetProposalComparator());
        for (TransformationRuleSet xRule : xRules) {
            this.ruleCombo.add(xRule.getName());
        }
        this.ruleCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.ruleCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddMigrationPathDialog.this.rule = AddMigrationPathDialog.this.ruleCombo.getItem(AddMigrationPathDialog.this.ruleCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ruleCombo.select(0);
        this.rule = this.ruleCombo.getItem(0);
        this.deleteAtSource = new Button(childArea, 32);
        this.deleteAtSource.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, gridLayout.numColumns, 1));
        this.deleteAtSource.setText(Messages.getString("MigrationPath.dialog.das"));
        this.deleteAtSource.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddMigrationPathDialog.this.das = AddMigrationPathDialog.this.deleteAtSource.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deleteAtSource.setSelection(false);
        this.das = this.deleteAtSource.getSelection();
        this.checkButtons();
        this.setTitle(Messages.getString("migpath.dialog.add.title"));
        this.getShell().setText(Messages.getString("migpath.dialog.add.title"));
        this.setTitleImage(UIActivator.getImage(UIActivator.IMGD520_MIGRATION_SCHEME_NEW_WIZARD));
        this.setMessage(Messages.getString("migpath.dialog.add.description"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.cm.ui.dialog_addmigrationpath");
        return c;
    }

    private void checkButtons() {
        if (this.sourceCombo != null & this.targetCombo != null && this.addButton != null) {
            if (this.sourceCombo.getItemCount() < 1 || this.sourceCombo.getItem(0).equals(NO_CONFIGURATIONS) || this.targetCombo.getItemCount() < 1 || this.targetCombo.getItem(0).equals(NO_CONFIGURATIONS)) {
                this.addButton.setEnabled(false);
            } else {
                this.setErrorMessage(null);
                for (MigrationPath path : this.paths) {
                    if (!path.getSource().equals(this.source) || !path.getTarget().equals(this.target)) continue;
                    this.setErrorMessage(Messages.getString("MigrationPath.error.alreadyAdded"));
                    break;
                }
                this.addButton.setEnabled(this.getErrorMessage() == null);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.addButton = this.createButton(parent, 0, Messages.getString("csd.dialog.button.add"), true);
        this.addButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.checkButtons();
    }

    private Combo createConfigurationSelectionCombo(Composite composite) {
        Combo configurationCombo = new Combo(composite, 8);
        List confs = ConfigurationManager.getCurrent().getConfigurationsNameList();
        Collections.sort(confs);
        for (String conf : confs) {
            configurationCombo.add(conf);
        }
        if (configurationCombo.getItemCount() < 1) {
            configurationCombo.add(NO_CONFIGURATIONS);
        }
        configurationCombo.select(0);
        return configurationCombo;
    }

    public MigrationPath getMigrationPath() {
        return new MigrationPath(this.source, this.target, this.rule.equals(NO_RULE) ? "" : this.rule, this.das);
    }

    private class TransformationRuleSetProposalComparator
    implements Comparator<TransformationRuleSet> {
        private TransformationRuleSetProposalComparator() {
        }

        @Override
        public int compare(TransformationRuleSet prop0, TransformationRuleSet prop1) {
            return prop0.getName().compareTo(prop1.getName());
        }
    }
}

