/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.model.IllegalAttributeException;
import com.ibm.cics.cm.ui.composites.FilterComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class StringComposite
extends FilterComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text text;
    private Composite stringComposite;

    @Override
    public Composite createComposite(Composite parent) {
        if (this.stringComposite == null) {
            this.stringComposite = this.createBasicComposite(parent);
            this.text = new Text(this.stringComposite, 2048);
            GridData data = new GridData(4, 4, true, false);
            this.text.setLayoutData((Object)data);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringComposite.this.refresh();
                }
            });
        }
        return this.stringComposite;
    }

    @Override
    protected void refresh() {
        String textValue = this.text.getText();
        if (this.filterExpression != null) {
            this.filterExpression.setValue((Object)textValue);
        }
        try {
            this.attribute.validate(textValue);
            this.updateErrorMessages(null);
        }
        catch (IllegalAttributeException ex) {
            String message = this.attribute.getErrorMessage(textValue);
            this.updateErrorMessages(message);
            this.notifyListeners();
            return;
        }
        this.notifyListeners();
    }

    @Override
    public void initialize() {
        if (this.filterExpression == null) {
            this.filterExpression = this.attribute.getFilterExpression();
            this.filterExpression.setPropertyName(this.displayName);
        }
        this.operatorSelectionToolItem.setText(this.filterExpression.getOperatorDisplayName());
        this.operatorSelectionToolItem.setToolTipText(this.filterExpression.getOperatorDisplayName());
        if (this.filterExpression.getValue() != null) {
            this.text.setText((String)this.filterExpression.getValue());
        }
    }

    @Override
    public void clearComposite() {
        this.filterExpression = null;
        this.text.setText("");
    }
}

