/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.ui.composites.FilterComposite;
import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;

public class DateComposite
extends FilterComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Calendar calendar;
    private DateTime calendarComposite;
    private DateTime timeComposite;
    private DateTime dateComposite;
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2);

    @Override
    public Composite createComposite(Composite parent) {
        Composite basicComposite = this.createBasicComposite(parent);
        ScrolledComposite sc = new ScrolledComposite(basicComposite, 2560);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = new Composite((Composite)sc, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        this.calendarComposite = new DateTime(composite, 3072);
        this.calendarComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateComposite.this.calendar.set(1, DateComposite.this.calendarComposite.getYear());
                DateComposite.this.calendar.set(2, DateComposite.this.calendarComposite.getMonth());
                DateComposite.this.calendar.set(5, DateComposite.this.calendarComposite.getDay());
                DateComposite.this.refresh();
            }
        });
        Composite bottomComposite = new Composite(composite, 0);
        gridLayout = new GridLayout(2, false);
        bottomComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, true, true);
        bottomComposite.setLayoutData((Object)data);
        this.dateComposite = new DateTime(bottomComposite, 2080);
        this.dateComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateComposite.this.calendar.set(1, DateComposite.this.dateComposite.getYear());
                DateComposite.this.calendar.set(2, DateComposite.this.dateComposite.getMonth());
                DateComposite.this.calendar.set(5, DateComposite.this.dateComposite.getDay());
                DateComposite.this.refresh();
            }
        });
        this.timeComposite = new DateTime(bottomComposite, 2176);
        this.timeComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateComposite.this.calendar.set(11, DateComposite.this.timeComposite.getHours());
                DateComposite.this.calendar.set(12, DateComposite.this.timeComposite.getMinutes());
                DateComposite.this.calendar.set(13, DateComposite.this.timeComposite.getSeconds());
                DateComposite.this.refresh();
            }
        });
        data = new GridData(4, 4, true, true);
        Point computeSize = basicComposite.computeSize(-1, -1);
        data.widthHint = computeSize.x;
        data.heightHint = computeSize.y;
        data.minimumHeight = computeSize.y;
        data.minimumWidth = computeSize.x;
        basicComposite.setLayoutData((Object)data);
        sc.setContent((Control)composite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(composite.computeSize(-1, -1));
        sc.setShowFocusedControl(true);
        return basicComposite;
    }

    @Override
    public void initialize() {
        if (this.filterExpression == null) {
            this.filterExpression = new FilterExpression(){

                public String getOperatorDisplayName() {
                    return this.getOperator().getTimeDisplayName();
                }

                protected String getValueXMLString() {
                    Calendar c = (Calendar)this.getValue();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(c.get(1));
                    buffer.append('/');
                    int month = c.get(2);
                    if (month < 10) {
                        buffer.append(0);
                    }
                    buffer.append(month);
                    buffer.append('/');
                    int day = c.get(5);
                    if (day < 10) {
                        buffer.append(0);
                    }
                    buffer.append(day);
                    buffer.append(" ");
                    int hours = c.get(11);
                    if (hours < 10) {
                        buffer.append(0);
                    }
                    buffer.append(hours);
                    buffer.append(':');
                    int minutes = c.get(12);
                    if (minutes < 10) {
                        buffer.append(0);
                    }
                    buffer.append(minutes);
                    buffer.append(':');
                    int seconds = c.get(13);
                    if (seconds < 10) {
                        buffer.append(0);
                    }
                    buffer.append(seconds);
                    return buffer.toString();
                }

                protected String getValueDisplayName() {
                    return dateFormat.format(((Calendar)this.getValue()).getTime());
                }
            };
            this.attribute.setFilterExpression(this.filterExpression);
            this.filterExpression.setAttribute(this.attribute);
            this.calendar = Calendar.getInstance();
            this.filterExpression.setValue((Object)this.calendar);
            this.filterExpression.setPropertyName(this.displayName);
        }
        this.refresh();
    }

    @Override
    public String getDisplayName(FilterExpression.Operator oper) {
        return oper.getTimeDisplayName();
    }

    @Override
    public void clearComposite() {
        this.filterExpression = null;
    }

    @Override
    protected void refresh() {
        this.calendarComposite.setDate(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
        this.timeComposite.setTime(this.calendar.get(11), this.calendar.get(12), this.calendar.get(13));
        this.dateComposite.setDate(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
        this.filterExpression.setValue((Object)this.calendar);
        this.notifyListeners();
    }
}

