/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.chgpkg;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class MigrationSchemeLabelProvider
implements ILabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean includeDescription = false;
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getImage(Object element) {
        if (element instanceof ChangePackage) {
            return ImageFactory.getMigrationSchemeImage();
        }
        if (element instanceof ChangePackageTreeNode && ((ChangePackageTreeNode)element).getNodeType().equals("SCHEME")) {
            return ImageFactory.getMigrationSchemeImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof MigrationScheme) {
            String description;
            MigrationScheme scheme = (MigrationScheme)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(scheme.getName());
            if (this.includeDescription && (description = scheme.getDescription()) != null && !description.trim().isEmpty()) {
                buffer.append(" - ");
                buffer.append(scheme.getDescription());
            }
            return buffer.toString();
        }
        return element.toString();
    }

    public boolean isIncludeDescription() {
        return this.includeDescription;
    }

    public void setIncludeDescription(boolean includeDescription) {
        this.includeDescription = includeDescription;
    }
}

