/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.chgpkg;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ReadyListObject;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageTreeNode;
import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ChangePackageTreeContentProvider
implements ITreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Viewer viewer = null;
    private boolean groupByResourceType = true;
    private boolean showPackageChildren = false;

    public void setGroupByResourceType(boolean groupByType) {
        this.groupByResourceType = groupByType;
    }

    public void setShowPackageChildren(boolean showPackageChildren) {
        this.showPackageChildren = showPackageChildren;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return ((IFilteredCollection)inputElement).toArray();
    }

    public Object[] getChildren(Object parentElement) {
        Object data;
        ArrayList<ChangePackageTreeNode> list = new ArrayList<ChangePackageTreeNode>();
        if (parentElement instanceof ChangePackage) {
            if (this.showPackageChildren) {
                ChangePackage cp = (ChangePackage)parentElement;
                String migScheme = (String)cp.getAttributes().get("LC_SCHEME");
                migScheme = migScheme == null ? "" : migScheme;
                list.add(new ChangePackageTreeNode("Migration Scheme : " + migScheme, "SCHEME", null, true));
                String approvalProf = (String)cp.getAttributes().get("APPPROF");
                approvalProf = approvalProf == null ? "<Blank>" : approvalProf;
                list.add(new ChangePackageTreeNode("Approval Profile : " + approvalProf, "APPROVAL", null, true));
                IFilteredCollection resources = cp.getResources(null);
                int resourceCount = resources.size();
                list.add(new ChangePackageTreeNode("Resources (" + resourceCount + ")", "FOLDER", resources, true));
                IFilteredCollection commands = cp.getCommands(null);
                int commandCount = commands.size();
                list.add(new ChangePackageTreeNode("Commands (" + commandCount + ")", "FOLDER", commands, true));
            }
            return list.toArray();
        }
        if (parentElement instanceof ChangePackageTreeNode && (data = ((ChangePackageTreeNode)parentElement).getData()) != null) {
            IFilteredCollection items;
            if (data instanceof IFilteredCollection && (items = (IFilteredCollection)data).size() > 0) {
                if (this.groupByResourceType) {
                    return ChangePackageTreeContentProvider.resourcesGroupedByType(items);
                }
                return items.toArray();
            }
            if (data instanceof Object[]) {
                return (Object[])data;
            }
        }
        return null;
    }

    public static Object[] resourcesGroupedByType(IFilteredCollection<?> items) {
        Object[] array = items.getResults().toArray();
        ArrayList<ReadyListObject> readyObjects = new ArrayList<ReadyListObject>();
        int i = 0;
        while (i < array.length) {
            if (array[i] instanceof ReadyListObject) {
                readyObjects.add((ReadyListObject)array[i]);
            }
            ++i;
        }
        TreeMap map = new TreeMap();
        for (ReadyListObject next : readyObjects) {
            String type = (String)next.getAttributes().get("SEL_OBJTYPE");
            if (!map.containsKey(type)) {
                map.put(type, new ArrayList());
            }
            ((ArrayList)map.get(type)).add(next);
        }
        Object[] output = new Object[map.keySet().size()];
        int arrayCount = 0;
        for (String type : map.keySet()) {
            ArrayList resources = (ArrayList)map.get(type);
            String descriptiveTypeName = String.valueOf(CMUIUtilities.getDescriptiveTypeNamePlural(type)) + " (" + resources.size() + ")";
            output[arrayCount] = new ChangePackageTreeNode(descriptiveTypeName, "FOLDER", resources.toArray(), true);
            ++arrayCount;
        }
        return output;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object data;
        if (element instanceof ChangePackage) {
            return this.showPackageChildren;
        }
        if (element instanceof ChangePackageTreeNode && (data = ((ChangePackageTreeNode)element).getData()) != null) {
            if (data instanceof IFilteredCollection) {
                return ((IFilteredCollection)data).size() > 0;
            }
            if (data instanceof Object[]) {
                return ((Object[])data).length > 0;
            }
        }
        return false;
    }
}

