/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.chgpkg;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ReadyListCommand;
import com.ibm.cics.cm.model.ReadyListObject;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageTreeNode;
import com.ibm.cics.core.ui.UIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ChangePackageLabelProvider
implements ILabelProvider,
Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public Image getImage(Object element) {
        if (element instanceof ChangePackage) {
            return ImageFactory.getChangePackageImage();
        }
        if (element instanceof ChangePackageTreeNode) {
            if (((ChangePackageTreeNode)element).getNodeType().equals("FOLDER")) {
                return ImageFactory.getFolderImage();
            }
            if (((ChangePackageTreeNode)element).getNodeType().equals("SCHEME")) {
                return ImageFactory.getMigrationSchemeImage();
            }
            if (((ChangePackageTreeNode)element).getNodeType().equals("APPROVAL")) {
                return ImageFactory.getApprovalProfileImage();
            }
        }
        if (element instanceof ReadyListObject) {
            ImageDescriptor imageDescriptor;
            ICMDefinition resource = ((ReadyListObject)element).getResource();
            String type = resource.getType();
            if (type.equals("ZFSFILE")) {
                imageDescriptor = UIActivator.IMG_ZFS_DEFINITION;
            } else {
                if (type.equals("CSGLCGCS")) {
                    type = "CSYSDEF";
                } else if (type.equals("CSGLCGCG")) {
                    type = "CSYSGRP";
                } else if (resource.getType().equals("LNKSWSCS")) {
                    type = "WLMSPEC";
                } else if (resource.getType().equals("LNKSWSCG")) {
                    type = "WLMSPEC";
                } else if (resource.getType().equals("WLMINSPC")) {
                    type = "WLMGROUP";
                } else if (resource.getType().equals("WLMINGRP")) {
                    type = "WLMDEF";
                } else if (resource.getType().equals("DTRINGRP")) {
                    type = "TRANGRP";
                }
                imageDescriptor = UIPlugin.getImageDescriptor((String)("icons/" + type + ".GIF"));
            }
            if (imageDescriptor != null) {
                return UIActivator.getImage(imageDescriptor);
            }
            return ImageFactory.getGeneralImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ChangePackage) {
            return ((ChangePackage)element).getName();
        }
        if (element instanceof ChangePackageTreeNode) {
            return ((ChangePackageTreeNode)element).getName();
        }
        if (element instanceof ReadyListObject) {
            String tempStr;
            ReadyListObject rlo = (ReadyListObject)element;
            String resourceString = rlo.getName();
            if (rlo.isCommand()) {
                return ((ReadyListCommand)rlo).wrapDescriptiveCommandText(resourceString);
            }
            ICMDefinition resource = rlo.getResource();
            String type = resource.getType();
            if ((ResourceDefinitionFactory.isCMCPSMResourceAssociationType((String)type) || ResourceDefinitionFactory.isCMCPSMResourceDefinitionType((String)type)) && (tempStr = CMUIUtilities.getDescriptiveNameForCPSMNoGroupResource(resource)) != null) {
                resourceString = tempStr;
            }
            return resourceString;
        }
        return element.toString();
    }
}

