/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceDefinitionGroupContext;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IAdapterFactory;

public class SMCMResourceGroupAdapterFactory
implements IAdapterFactory {
    private WeakHashMap<Object, ResourceDefinitionGroup> cachedAdapters = new WeakHashMap();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ISystemManagerConnection connection = UIPlugin.getCPSM().getConnection();
        if (connection == null || !(connection instanceof ICMSMConnection)) {
            return null;
        }
        String resourceType = null;
        if (adaptableObject instanceof IResourceGroupDefinition) {
            resourceType = "RESGROUP";
        } else if (adaptableObject instanceof ICSDGroupDefinition) {
            resourceType = "CSDGROUP";
        }
        if (adaptableObject instanceof IResourceGroupDefinition || adaptableObject instanceof ICSDGroupDefinition) {
            ResourceDefinitionGroup group = this.cachedAdapters.get(adaptableObject);
            if (group == null) {
                IContext context = CMUtilities.getIContext((Object)adaptableObject);
                if (context instanceof IFilteredContext) {
                    context = ((IFilteredContext)context).getParentContext();
                }
                if (context instanceof IDefinitionContext) {
                    context = ((ICMSMConnection)connection).getResourceGroupContext(context, resourceType);
                }
                if (context instanceof ResourceDefinitionGroupContext) {
                    ResourceDefinitionGroupContext cmContext = (ResourceDefinitionGroupContext)context;
                    group = cmContext.getResourceDefinitionGroup();
                    this.cachedAdapters.put(adaptableObject, group);
                }
            }
            return group;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ResourceDefinitionGroup.class, IHistoryProvider.class};
    }
}

