/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceDefinitionGroupContext;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.context.IGroupContext;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdapterFactory;

public class SMCMAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(SMCMAdapterFactory.class.getPackage().getName());
    private Map<ICICSDefinition, ICMDefinition> cachedAdapters = new WeakHashMap<ICICSDefinition, ICMDefinition>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ISystemManagerConnection connection = UIPlugin.getCPSM().getConnection();
        if (connection == null || !(connection instanceof ICMSMConnection)) {
            return null;
        }
        if (!(adaptableObject instanceof ICICSDefinition)) {
            return null;
        }
        Map<ICICSDefinition, ICMDefinition> map = this.cachedAdapters;
        synchronized (map) {
            ICICSDefinition cicsDefinition = (ICICSDefinition)adaptableObject;
            ICMDefinition definition = this.cachedAdapters.get(cicsDefinition);
            if (definition != null) {
                return definition;
            }
            IPrimaryKey context = (IPrimaryKey)((ICoreObject)cicsDefinition).getAdapter(IPrimaryKey.class);
            Configuration config = null;
            ResourceDefinitionGroup resGroup = null;
            config = CMSMConnection.getConfiguration((IContext)context);
            if (context instanceof ResourceDefinitionGroupContext) {
                resGroup = ((ResourceDefinitionGroupContext)context).getResourceDefinitionGroup();
            } else if (context instanceof IGroupContext) {
                if (config == null) {
                    return null;
                }
                IGroupContext groupContext = (IGroupContext)context;
                String resourceGroup = groupContext.getResourceGroup();
                if (resourceGroup == null) {
                    resourceGroup = ((IPrimaryKey)groupContext).getAttributeValue("CSDGROUP");
                }
                resGroup = config.getResourceGroup(resourceGroup);
            } else if (context instanceof IFilteredContext) {
                IFilteredContext filteredContext = (IFilteredContext)context;
                if ((context = filteredContext.getParentContext()) instanceof ResourceDefinitionGroupContext) {
                    resGroup = ((ResourceDefinitionGroupContext)context).getResourceDefinitionGroup();
                } else if (context instanceof IGroupContext) {
                    if (config == null) {
                        return null;
                    }
                    IGroupContext groupContext = (IGroupContext)context;
                    String resourceGroup = groupContext.getResourceGroup();
                    resGroup = config.getResourceGroup(resourceGroup);
                }
            }
            if (resGroup == null && config != null) {
                definition = config.getDefinition(CMUIUtilities.getTypeAsString(cicsDefinition), cicsDefinition.getName());
                if (definition == null) {
                    String defType = CMUIUtilities.getTypeAsString(cicsDefinition);
                    String defName = cicsDefinition.getName();
                    logger.logp(Level.WARNING, SMCMAdapterFactory.class.getName(), "getAdapter", "Failed to adapt CICS Definition " + defType + " " + defName + " to CM Definition. Is it an orphan?");
                }
            } else {
                definition = resGroup.getDefinition(CMUIUtilities.getTypeAsString(cicsDefinition), cicsDefinition.getName());
            }
            this.cachedAdapters.put(cicsDefinition, definition);
            return definition;
        }
    }

    public Class[] getAdapterList() {
        return new Class[]{ICMDefinition.class, IHistoryProvider.class};
    }
}

