/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceDefinitionGroupContext;
import com.ibm.cics.cm.model.definitions.CICSRegionDefinition;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupDefinition;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.context.IGroupContext;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdapterFactory;

public class CPSMTopologyAdapterFactory
implements IAdapterFactory,
Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CPSMTopologyAdapterFactory.class.getPackage().getName());
    private Map<ICPSMDefinition, ICMDefinition> cachedAdapters = new WeakHashMap<ICPSMDefinition, ICMDefinition>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ISystemManagerConnection connection = UIPlugin.getCPSM().getConnection();
        if (connection == null || !(connection instanceof ICMSMConnection)) {
            return null;
        }
        if (!(adaptableObject instanceof ICICSRegionDefinition) && !(adaptableObject instanceof ICICSRegionGroupDefinition)) {
            return null;
        }
        Map<ICPSMDefinition, ICMDefinition> map = this.cachedAdapters;
        synchronized (map) {
            ICPSMDefinition iDefinition = (ICPSMDefinition)adaptableObject;
            ICMDefinition definition = this.cachedAdapters.get(iDefinition);
            if (definition != null) {
                return definition;
            }
            IPrimaryKey context = (IPrimaryKey)((ICoreObject)iDefinition).getAdapter(IPrimaryKey.class);
            Configuration config = null;
            ResourceDefinitionGroup resGroup = null;
            config = CMSMConnection.getConfiguration((IContext)context);
            if (context instanceof ResourceDefinitionGroupContext) {
                resGroup = ((ResourceDefinitionGroupContext)context).getResourceDefinitionGroup();
            } else if (context instanceof IGroupContext) {
                if (config == null) {
                    return null;
                }
                IGroupContext groupContext = (IGroupContext)context;
                String resourceGroup = groupContext.getResourceGroup();
                if (resourceGroup == null) {
                    resourceGroup = ((IPrimaryKey)groupContext).getAttributeValue("CSDGROUP");
                }
                resGroup = config.getResourceGroup(resourceGroup);
            } else if (context instanceof IFilteredContext) {
                IFilteredContext filteredContext = (IFilteredContext)context;
                if ((context = filteredContext.getParentContext()) instanceof ResourceDefinitionGroupContext) {
                    resGroup = ((ResourceDefinitionGroupContext)context).getResourceDefinitionGroup();
                } else if (context instanceof IGroupContext) {
                    if (config == null) {
                        return null;
                    }
                    IGroupContext groupContext = (IGroupContext)context;
                    String resourceGroup = groupContext.getResourceGroup();
                    resGroup = config.getResourceGroup(resourceGroup);
                }
            }
            String name = iDefinition.getName();
            String type = "CSYSDEF";
            if (adaptableObject instanceof ICICSRegionGroupDefinition) {
                type = "CSYSGRP";
            }
            if (resGroup == null && config != null) {
                definition = config.getDefinition(type, name);
                if (definition == null) {
                    String defType = type;
                    String defName = name;
                    logger.logp(Level.WARNING, CPSMTopologyAdapterFactory.class.getName(), "getAdapter", "Failed to adapt CICS CPSM Topology Definition " + defType + " " + defName + " to CM CPSM Topology Definition.");
                }
            } else {
                definition = resGroup.getDefinition(type, name);
            }
            this.cachedAdapters.put(iDefinition, definition);
            return definition;
        }
    }

    public Class[] getAdapterList() {
        return new Class[]{CICSRegionDefinition.class, CICSRegionGroupDefinition.class, IHistoryProvider.class};
    }
}

