/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.ui.adapters.Messages;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class CMObjectPropertySource
implements IPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICMObject cmDefinition;
    Map<String, String> attributes;

    public CMObjectPropertySource(ICMObject aCMDefinition) {
        this.cmDefinition = aCMDefinition;
        this.attributes = aCMDefinition.getAttributes();
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] result = new IPropertyDescriptor[this.attributes.size()];
        Iterator<Map.Entry<String, String>> iter = this.attributes.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry<String, String> keyValueEntry = iter.next();
            final String attributeName = keyValueEntry.getKey();
            result[i] = new IPropertyDescriptor(){

                public CellEditor createPropertyEditor(Composite parent) {
                    return null;
                }

                public String getCategory() {
                    return Messages.getString("CMObjectPropertySource.category");
                }

                public String getDescription() {
                    return attributeName;
                }

                public String getDisplayName() {
                    return attributeName;
                }

                public String[] getFilterFlags() {
                    return null;
                }

                public Object getHelpContextIds() {
                    return null;
                }

                public Object getId() {
                    return attributeName;
                }

                public ILabelProvider getLabelProvider() {
                    return null;
                }

                public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
                    return false;
                }
            };
            ++i;
        }
        return result;
    }

    public Object getPropertyValue(Object id) {
        return this.attributes.get(id);
    }

    public boolean isPropertySet(Object id) {
        return this.attributes.containsKey(id);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

