/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.cm.ui.search.OrphanedResourcesQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ShowOrphanedResources
extends Action
implements IObjectActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private StructuredSelection selection;
    private IWorkbenchPart targetPart;
    private List<Configuration> configurations = new ArrayList<Configuration>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.getString("ShowOrphanedResources.desc"));
        boolean first = true;
        if (this.selection != null) {
            Iterator iterator = this.selection.iterator();
            this.configurations.clear();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof CPSMConfiguration)) continue;
                CPSMConfiguration configuration = (CPSMConfiguration)object;
                this.configurations.add((Configuration)configuration);
                if (!first) {
                    buffer.append(',');
                    buffer.append(' ');
                } else {
                    first = false;
                }
                buffer.append(configuration.getName());
            }
        }
        OrphanedResourcesQuery orphanedResourcesQuery = new OrphanedResourcesQuery(buffer.toString(), this.configurations);
        UIActivator.executeSearch(orphanedResourcesQuery);
    }

    public void selectionChanged(IAction action, ISelection aSelection) {
        if (aSelection instanceof StructuredSelection) {
            this.selection = (StructuredSelection)aSelection;
        }
    }
}

