/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.cm.ui.search.AllResourcesForConfigurationSearchQuery;
import com.ibm.cics.cm.ui.search.AllResourcesForGroupSearchQuery;
import com.ibm.cics.cm.ui.search.CMDialogSearchQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ShowAllResources
extends Action
implements IObjectActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IWorkbenchPart targetPart;
    private StructuredSelection selection;
    private List<ResourceDefinitionGroup> selectedGroups = new ArrayList<ResourceDefinitionGroup>();
    private List<Configuration> selectedConfigurations = new ArrayList<Configuration>();
    private Configuration currentConfiguration;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.getString("ShowAllResources.desc"));
        boolean first = true;
        if (this.selection != null) {
            Iterator iterator = this.selection.iterator();
            this.selectedConfigurations = new ArrayList<Configuration>();
            this.selectedGroups = new ArrayList<ResourceDefinitionGroup>();
            String previousConfigurationName = null;
            while (iterator.hasNext()) {
                String name = "";
                Object object = iterator.next();
                Boolean changed = false;
                if (object instanceof Configuration) {
                    Configuration configuration = (Configuration)object;
                    this.selectedConfigurations.add(configuration);
                    name = configuration.getName();
                    changed = true;
                } else if (object instanceof ResourceDefinitionGroup) {
                    ResourceDefinitionGroup group = (ResourceDefinitionGroup)object;
                    this.selectedGroups.add(group);
                    this.currentConfiguration = group.getConfiguration();
                    if (!this.currentConfiguration.getName().equals(previousConfigurationName)) {
                        this.selectedConfigurations.add(this.currentConfiguration);
                        previousConfigurationName = this.currentConfiguration.getName();
                        name = this.currentConfiguration.getName();
                        changed = true;
                    }
                }
                if (changed.booleanValue()) {
                    if (!first) {
                        buffer.append(',');
                        buffer.append(' ');
                    } else {
                        first = false;
                    }
                    buffer.append(name);
                }
                changed = false;
            }
        }
        CMDialogSearchQuery query = this.selectedGroups.isEmpty() ? new AllResourcesForConfigurationSearchQuery(buffer.toString(), this.selectedConfigurations) : new AllResourcesForGroupSearchQuery(buffer.toString(), this.selectedGroups, this.selectedConfigurations);
        UIActivator.executeSearch(query);
    }

    public void selectionChanged(IAction action, ISelection aSelection) {
        if (aSelection instanceof StructuredSelection) {
            this.selection = (StructuredSelection)aSelection;
        }
    }
}

