/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.cm.ui.search.AllListsForConfigurationQuery;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ShowAllLists
extends Action
implements IObjectActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IWorkbenchPart targetPart;
    private StructuredSelection selection;
    private List<Configuration> selectedConfigurations = new ArrayList<Configuration>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        if (this.selection != null) {
            Iterator iterator = this.selection.iterator();
            this.selectedConfigurations.clear();
            Object previousConfigurationName = null;
            while (iterator.hasNext()) {
                String name = "";
                Object object = iterator.next();
                if (object instanceof Configuration) {
                    Configuration configuration = (Configuration)object;
                    this.selectedConfigurations.add(configuration);
                    name = configuration.getName();
                }
                if (!first) {
                    buffer.append(',');
                    buffer.append(' ');
                } else {
                    first = false;
                }
                buffer.append(name);
            }
        }
        UIActivator.executeSearch(new AllListsForConfigurationQuery(MessageFormat.format(Messages.getString("ShowAllLists.description"), buffer.toString()), this.selectedConfigurations));
    }

    public void selectionChanged(IAction action, ISelection aSelection) {
        if (aSelection instanceof StructuredSelection) {
            this.selection = (StructuredSelection)aSelection;
        }
    }
}

