/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.cm.ui.search.CMDialogSearchQuery;
import com.ibm.cics.model.ICICSDefinition;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SearchForSimilarResources
extends Action
implements IObjectActionDelegate,
IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private StructuredSelection selection;
    private String all;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        ICMDefinition cmDefinition = null;
        Object firstElement = this.selection.getFirstElement();
        if (firstElement instanceof ICICSDefinition) {
            cmDefinition = (ICMDefinition)Platform.getAdapterManager().getAdapter(this.selection.getFirstElement(), ICMDefinition.class);
        } else if (firstElement instanceof ICMDefinition) {
            cmDefinition = (ICMDefinition)firstElement;
        }
        if (cmDefinition != null) {
            Configuration configuration = cmDefinition.getConfiguration();
            String description = MessageFormat.format(Messages.getString("SearchForSimilarResources.0"), cmDefinition.getType(), cmDefinition.getName(), configuration.getName());
            CMDialogSearchQuery query = new CMDialogSearchQuery(description, cmDefinition.getName(), cmDefinition.getType(), null, configuration);
            UIActivator.executeSearch(query);
        }
    }

    public void selectionChanged(IAction action, ISelection aSelection) {
        if (aSelection instanceof StructuredSelection) {
            this.selection = (StructuredSelection)aSelection;
        }
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        this.selectionChanged(null, selection);
        this.run(null);
        return null;
    }

    public boolean isHandled() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

