/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.ui.actions.CSDInstallDialog;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.IDefinition;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class InstallDefinitionHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<? extends IDefinition> targets;
    private List<IHandlerListener> listeners = new ArrayList<IHandlerListener>();

    public void addHandlerListener(IHandlerListener handlerListener) {
        this.listeners.add(handlerListener);
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        this.listeners.remove(handlerListener);
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        CSDInstallDialog installDialog = new CSDInstallDialog(shell);
        installDialog.setBlockOnOpen(true);
        installDialog.setTargets(this.getTargets(selection));
        installDialog.open();
        return null;
    }

    public boolean isEnabled() {
        boolean csdFound = false;
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Object activeMenuSelection = handlerService.getCurrentState().getVariable("activeMenuSelection");
        if (activeMenuSelection instanceof ISelection) {
            this.getTargets((ISelection)activeMenuSelection);
            for (IDefinition iDefinition : this.targets) {
                if (iDefinition instanceof ICICSDefinition) {
                    ICICSDefinition cicsDef = (ICICSDefinition)iDefinition;
                    String csdGroup = cicsDef.getCSDGroup();
                    if (!StringUtil.hasContent((String)csdGroup)) continue;
                    csdFound = true;
                    continue;
                }
                if (!(iDefinition instanceof ICSDGroupDefinition)) continue;
                csdFound = true;
            }
        }
        return csdFound;
    }

    public boolean isHandled() {
        return true;
    }

    protected List<? extends IDefinition> getTargets(ISelection selection) {
        List tempList = ((IStructuredSelection)selection).toList();
        ArrayList<? extends IDefinition> validList = new ArrayList<IDefinition>();
        for (Object tempObj : tempList) {
            if (tempObj instanceof ResourceDefinition) {
                validList.add((IDefinition)((ResourceDefinition)tempObj).asCICSDefinition());
                continue;
            }
            if (!(tempObj instanceof IDefinition)) continue;
            validList.add((IDefinition)((IDefinition)tempObj));
        }
        this.targets = validList;
        return this.targets;
    }
}

