/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.cm.ui.search.CMSearchInGroupsQuery;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.model.ICICSType;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class FindCurrentVersionActionDelegate
extends Action
implements IObjectActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private History history;
    private IViewPart activePart;
    Logger logger = Logger.getLogger("com.ibm.cics.cm.ui.actions");

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof IViewPart) {
            this.activePart = (IViewPart)targetPart;
        }
    }

    public void run(IAction action) {
        ICICSType findForResourceTableName = null;
        if (this.history != null) {
            findForResourceTableName = CICSTypes.findForResourceTableName((String)this.history.getType());
        }
        if (this.history == null || findForResourceTableName == null) {
            return;
        }
        Configuration configuration = this.history.getProvider().getConfiguration();
        if (configuration == null) {
            this.logger.log(Level.WARNING, "Can't find valid Configuration to find current version", this.history);
            return;
        }
        String description = MessageFormat.format(Messages.getString("FindCurrentVersionActionDelegate.description.query"), this.history.getType(), this.history.getName(), configuration.getName(), this.history.getResourceGroup());
        ResourceDefinitionGroup resourceGroup = configuration.getResourceGroup(this.history.getResourceGroup());
        if (resourceGroup == null) {
            return;
        }
        CMSearchInGroupsQuery query = new CMSearchInGroupsQuery(description, this.history.getName(), this.history.getType(), null, configuration, resourceGroup);
        UIActivator.executeSearch(query);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.history = (History)((StructuredSelection)selection).getFirstElement();
        ICICSType findForResourceTableName = null;
        if (this.history != null) {
            findForResourceTableName = CICSTypes.findForResourceTableName((String)this.history.getType());
        }
        this.setEnabled(this.history != null && findForResourceTableName != null);
    }
}

