/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.CSDInstallExecutionDelegate;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.decorators.CICSObjectLabelProvider;
import com.ibm.cics.core.ui.editors.TypedObjectExplorerEditorInput;
import com.ibm.cics.eclipse.common.jobs.CancellableRunnable;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.meta.ITypedObject;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class CSDInstallDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Logger logger = Logger.getLogger(CSDInstallDialog.class.getPackage().getName());
    private ComboViewer repoComboViewer;
    private Group targetComposite;
    private CheckboxTreeViewer targetViewer;
    private Button disableCloseButton;
    private Button discardButton;
    private Set<ConfigurationConnection> installTargets = new HashSet<ConfigurationConnection>();
    private Thread t;
    private List<? extends IDefinition> definitions;
    private TableViewer definitionsViewer;

    public CSDInstallDialog(Shell parentShell) {
        super(parentShell);
        this.setTitleImage(UIActivator.IMGD_CPWIZ_INSTALL.createImage());
    }

    public void setTargets(List<? extends IDefinition> targets) {
        this.definitions = targets;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        c.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.makeColumnsEqualWidth = true;
        c.setLayout((Layout)layout);
        Composite targetArea = new Composite(c, 0);
        GridData grid = new GridData(1, 1, false, true);
        targetArea.setLayoutData((Object)grid);
        this.createTargetArea(targetArea);
        Composite definitionsArea = new Composite(c, 0);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)definitionsArea);
        this.createDefinitionsArea(definitionsArea);
        this.getShell().setText(Messages.getString("CSDInstallDialog.operationName"));
        this.setTitle(Messages.getString("CSDInstallDialog.header.title"));
        this.setMessage(Messages.getString("CSDInstallDialog.dialog.message"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), this.getHelpContextID());
        return c;
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.dialog_csd_install";
    }

    private void createTargetArea(Composite area) {
        GridLayout layout = new GridLayout(2, false);
        area.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        area.setLayoutData((Object)data);
        new Label(area, 0).setText(Messages.getString("CSDInstallDialog.repoLabel"));
        Combo repoCombo = new Combo(area, 8);
        data = new GridData(4, 128, true, false);
        repoCombo.setLayoutData((Object)data);
        this.repoComboViewer = new ComboViewer(repoCombo);
        this.repoComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repoComboViewer.setLabelProvider((IBaseLabelProvider)new CMConfigComboLabelProvider());
        this.repoComboViewer.setInput((Object)new Object[]{Messages.getString("CSDInstallDialog.fetching")});
        this.repoComboViewer.getCombo().select(0);
        this.repoComboViewer.getCombo().setEnabled(false);
        this.repoComboViewer.getCombo().addSelectionListener(this.getRepositorySelectionListener());
        this.targetComposite = new Group(area, 0);
        this.targetComposite.setText(Messages.getString("CSDInstallDialog.group.target"));
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.targetComposite.setLayoutData((Object)data);
        this.targetComposite.setLayout((Layout)new GridLayout(1, false));
        this.targetViewer = new CheckboxTreeViewer((Composite)this.targetComposite);
        this.targetViewer.setContentProvider((IContentProvider)new CSDConnectionContentProvider());
        this.targetViewer.setLabelProvider((IBaseLabelProvider)new CSDConnectionLabelProvider());
        this.targetViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                if (element instanceof ConfigurationConnection) {
                    boolean inService = ((ConfigurationConnection)element).isInService();
                    boolean acquired = ((ConfigurationConnection)element).isAcquired();
                    return !inService || !acquired;
                }
                return false;
            }

            public boolean isChecked(Object element) {
                return false;
            }
        });
        data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        Tree tree = this.targetViewer.getTree();
        tree.setLayoutData((Object)data);
        tree.setFocus();
        this.targetViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CSDInstallDialog.this.validateInstallTargets();
            }
        });
        Composite buttonArea = new Composite((Composite)this.targetComposite, 0);
        buttonArea.setLayout((Layout)new GridLayout(2, false));
        Button selectAllButton = new Button(buttonArea, 0);
        selectAllButton.setText(Messages.getString("CSDInstallDialog.button.selectAll"));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSDInstallDialog.this.selectAllTargets(true);
            }
        });
        Button deselectAllButton = new Button(buttonArea, 0);
        deselectAllButton.setText(Messages.getString("CSDInstallDialog.button.deselectAll"));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSDInstallDialog.this.selectAllTargets(false);
            }
        });
        Group optionsComposite = new Group(area, 0);
        optionsComposite.setText(Messages.getString("CSDInstallDialog.optionsGroup"));
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        optionsComposite.setLayoutData((Object)data);
        optionsComposite.setLayout((Layout)new GridLayout(1, false));
        this.disableCloseButton = new Button((Composite)optionsComposite, 32);
        this.disableCloseButton.setText(Messages.getString("CSDInstallDialog.disableCloseButton"));
        this.disableCloseButton.setSelection(true);
        this.discardButton = new Button((Composite)optionsComposite, 32);
        this.discardButton.setText(Messages.getString("CSDInstallDialog.discardButton"));
        this.discardButton.setSelection(true);
        this.loadTargets();
    }

    private void createDefinitionsArea(Composite area) {
        FillLayout layout = new FillLayout();
        area.setLayout((Layout)layout);
        Group definitionsGroup = new Group(area, 0);
        definitionsGroup.setText(Messages.getString("CSDInstallDialog.group.definitions"));
        layout = new GridLayout(1, false);
        definitionsGroup.setLayout((Layout)layout);
        this.definitionsViewer = new TableViewer((Composite)definitionsGroup);
        this.definitionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.definitionsViewer.setLabelProvider((IBaseLabelProvider)new CICSObjectLabelProvider());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.definitionsViewer.getTable());
        this.definitionsViewer.setInput(this.definitions);
    }

    private void loadTargets() {
        if (this.t == null) {
            this.t = new Thread(){

                @Override
                public void run() {
                    List results;
                    HashSet<Configuration> configsFromSelection = new HashSet<Configuration>();
                    ArrayList<IDefinition> validList = new ArrayList<IDefinition>();
                    for (Object next : CSDInstallDialog.this.definitions) {
                        if (!(next instanceof IDefinition)) {
                            ITypedObject editorObject;
                            if (!(next instanceof TypedObjectExplorerEditorInput) || !((editorObject = ((TypedObjectExplorerEditorInput)next).getObject()) instanceof IDefinition)) continue;
                            validList.add((IDefinition)editorObject);
                            continue;
                        }
                        validList.add((IDefinition)next);
                    }
                    CSDInstallDialog.this.definitions = validList;
                    for (Object next : CSDInstallDialog.this.definitions) {
                        IPrimaryKey pk = (IPrimaryKey)((ICoreObject)next).getAdapter(IPrimaryKey.class);
                        Configuration configuration = CMSMConnection.getConfiguration((IContext)pk);
                        if (configuration == null) continue;
                        configsFromSelection.add(configuration);
                    }
                    if (configsFromSelection.size() == 1) {
                        results = new ArrayList(configsFromSelection);
                    } else {
                        IFilteredCollection configurations = ConfigurationManager.getCurrent().getConfigurations();
                        results = configurations.getResults();
                    }
                    if (results.size() > 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!CSDInstallDialog.this.repoComboViewer.getCombo().isDisposed()) {
                                    CSDInstallDialog.this.repoComboViewer.setInput((Object)results);
                                    CSDInstallDialog.this.repoComboViewer.getCombo().setEnabled(true);
                                    if (results.size() == 1) {
                                        CSDInstallDialog.this.repoComboViewer.setSelection((ISelection)new StructuredSelection(results.get(0)));
                                        CSDInstallDialog.this.targetViewer.setInput((Object)new TargetRoot((Configuration)results.get(0)));
                                        CSDInstallDialog.this.getButton(0).setEnabled(false);
                                    }
                                }
                            }
                        });
                    } else {
                        CSDInstallDialog.this.logger.logp(Level.SEVERE, CSDInstallDialog.class.getName(), "loadTargets", "No targets were returned");
                    }
                }
            };
        }
        this.t.start();
    }

    protected void okPressed() {
        final CSDInstallExecutionDelegate executioner = new CSDInstallExecutionDelegate(this.installTargets.toArray(new ConfigurationConnection[0]), this.disableCloseButton.getSelection(), this.discardButton.getSelection());
        Iterator<? extends IDefinition> iterator = this.definitions.iterator();
        while (iterator.hasNext()) {
            IDefinition def;
            final IDefinition definition = def = iterator.next();
            CancellableRunnable cancellableRunnable = new CancellableRunnable(){

                protected Object performLongWork() throws Exception {
                    executioner.execute(definition);
                    return null;
                }
            };
            try {
                cancellableRunnable.run(null);
            }
            catch (CMServerException cMServerException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.okPressed();
    }

    private void selectAllTargets(boolean select) {
        TreeItem[] items = this.targetViewer.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            this.targetViewer.setSubtreeChecked(data, select);
            ++i;
        }
        this.validateInstallTargets();
    }

    private void validateInstallTargets() {
        this.installTargets.clear();
        TreeItem[] items = this.targetViewer.getTree().getItems();
        boolean atLeastOneValidTarget = false;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem next = treeItemArray[n2];
            Object data = next.getData();
            boolean isChecked = this.targetViewer.getChecked(data);
            boolean connIsUp = false;
            if (data instanceof ConfigurationConnection) {
                ConfigurationConnection cc = (ConfigurationConnection)data;
                boolean bl = connIsUp = cc.isAcquired() && cc.isInService();
                if (isChecked && connIsUp) {
                    this.installTargets.add(cc);
                    atLeastOneValidTarget = true;
                }
            }
            ++n2;
        }
        this.getButton(0).setEnabled(atLeastOneValidTarget);
    }

    protected SelectionListener getRepositorySelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((IStructuredSelection)CSDInstallDialog.this.repoComboViewer.getSelection()).getFirstElement();
                if (selection instanceof Configuration) {
                    CSDInstallDialog.this.targetViewer.setInput((Object)new TargetRoot((Configuration)selection));
                }
            }
        };
    }

    static class CMConfigComboLabelProvider
    extends LabelProvider {
        CMConfigComboLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof Configuration) {
                if (element instanceof CSDConfiguration) {
                    return UIActivator.getImage(UIActivator.IMGD520_CSD_CONFIGURATION);
                }
                return UIActivator.getImage(UIActivator.IMGD520_DATA_REPOSITORY_CONFIGURATION);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Configuration) {
                return ((Configuration)element).getName();
            }
            return element.toString();
        }
    }

    protected class CSDConnectionContentProvider
    implements ITreeContentProvider {
        protected CSDConnectionContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TargetRoot) {
                return ((TargetRoot)inputElement).getTargets();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    protected class CSDConnectionLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        protected CSDConnectionLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ConfigurationConnection) {
                return ((ConfigurationConnection)element).getName();
            }
            return element.toString();
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString styled = new StyledString(this.getText(element));
            if (element instanceof ConfigurationConnection) {
                boolean acquired;
                ConfigurationConnection cc = (ConfigurationConnection)element;
                String applid = cc.getApplid();
                if (StringUtil.hasContent((String)applid)) {
                    styled.append(" (" + applid + ")");
                }
                String servStatus = (acquired = cc.isAcquired()) ? Messages.getString("ConfConn.acquired") : Messages.getString("ConfConn.released");
                boolean inService = cc.isInService();
                String connStatus = inService ? Messages.getString("ConfConn.inservice") : Messages.getString("ConfConn.outservice");
                styled.append(" - " + servStatus + ", " + connStatus);
                if (!acquired || !inService) {
                    StyledString.Styler styler = new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.foreground = Display.getDefault().getSystemColor(33);
                        }
                    };
                    styled.setStyle(0, styled.length(), styler);
                }
            }
            cell.setText(styled.toString());
            cell.setStyleRanges(styled.getStyleRanges());
        }
    }

    private final class TargetRoot {
        private final Configuration config;

        public TargetRoot(Configuration config) {
            this.config = config;
        }

        public Object[] getTargets() {
            List connections = null;
            if (this.config instanceof CSDConfiguration) {
                connections = ((CSDConfiguration)this.config).getConnections();
            }
            if (connections == null) {
                return new Object[0];
            }
            return connections.toArray();
        }
    }
}

