/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ILocalFile;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IScopedContext;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class RegionConfigurationDecorator
implements ILightweightLabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger = Logger.getLogger(RegionConfigurationDecorator.class.getPackage().getName());

    public void decorate(Object element, IDecoration decoration) {
        IContextProvider contextProvider;
        IManagedRegion region;
        if (element instanceof IManagedRegion && (region = (IManagedRegion)element) instanceof IContextProvider && (contextProvider = (IContextProvider)region).getIContext() instanceof IScopedContext) {
            try {
                final IScopedContext parentContext = (IScopedContext)contextProvider.getIContext();
                final HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put(CICSTypes.LocalFile.getNameAttribute(), "DFHCSD");
                IPrimaryKey key = new IPrimaryKey(){

                    public String getContext() {
                        return parentContext.getContext();
                    }

                    public String getScope() {
                        return parentContext.getScope();
                    }

                    public IContext getParentContext() {
                        return parentContext;
                    }

                    public String getAttributeValue(String attributeName) {
                        return (String)attributes.get(attributeName);
                    }

                    public Set<String> getAttributeNames() {
                        return attributes.keySet();
                    }

                    public boolean matches(IPrimaryKey other) {
                        return false;
                    }
                };
                ICPSM cpsm = ((ICoreObject)region).getCPSM();
                ICICSObject icicsObject = cpsm.get((ICICSType)CICSTypes.LocalFile, key);
                if (icicsObject instanceof ILocalFile) {
                    ILocalFile file = (ILocalFile)icicsObject;
                    String datasetName = file.getDSName();
                    CSDConfiguration configurationForDatasetName = ConfigurationManager.getCurrent().getConfigurationForDatasetName(datasetName);
                    if (configurationForDatasetName != null) {
                        this.addSuffix(decoration, configurationForDatasetName.getName());
                    }
                }
            }
            catch (CICSSystemManagerException e) {
                Debug.event((Logger)logger, (String)RegionConfigurationDecorator.class.getName(), (String)"decorate", (Object)((Object)e));
            }
        }
    }

    private void addSuffix(IDecoration decoration, String suffix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" [");
        buffer.append(suffix);
        buffer.append("]");
        decoration.addSuffix(buffer.toString());
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

