/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.ui.ImageFactory;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class OperatorSelection {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite mainComposite;
    private List<FilterExpression.Operator> operators;
    private FilterExpression.Operator defaultOperator;

    public OperatorSelection(Composite mainComposite, List<FilterExpression.Operator> operators, FilterExpression.Operator defaultOperator) {
        this.mainComposite = mainComposite;
        this.operators = operators;
        this.defaultOperator = defaultOperator;
    }

    public ToolItem getSelectionToolBar() {
        final ToolBar toolBar = new ToolBar(this.mainComposite, 0x820000);
        toolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        final ToolItem operatorSelectionToolItem = new ToolItem(toolBar, 0x800004);
        final Menu operatorMenu = new Menu((Decorations)this.mainComposite.getShell(), 8);
        operatorSelectionToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = operatorSelectionToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                operatorMenu.setLocation(pt.x, pt.y);
                operatorMenu.setVisible(true);
            }
        });
        SelectionAdapter menuListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem selectedMenuItem = (MenuItem)e.getSource();
                FilterExpression.Operator operator = (FilterExpression.Operator)selectedMenuItem.getData();
                operatorSelectionToolItem.setText(OperatorSelection.this.getDisplayName(operator));
                operatorSelectionToolItem.setImage(ImageFactory.getImageForOperator(operator));
                operatorSelectionToolItem.setToolTipText(OperatorSelection.this.getDisplayName(operator));
                OperatorSelection.this.setOperator(operator);
            }
        };
        String longestName = "";
        for (FilterExpression.Operator oper : this.operators) {
            MenuItem menuItem = new MenuItem(operatorMenu, 8);
            String operatorName = this.getDisplayName(oper);
            if (longestName.length() < operatorName.length()) {
                longestName = operatorName;
            }
            menuItem.setText(operatorName);
            menuItem.setData((Object)oper);
            menuItem.setImage(ImageFactory.getImageForOperator(oper));
            menuItem.addSelectionListener((SelectionListener)menuListener);
        }
        operatorSelectionToolItem.setText(longestName);
        operatorSelectionToolItem.setImage(ImageFactory.getImageForOperator(this.defaultOperator));
        toolBar.layout();
        int x = toolBar.computeSize((int)-1, (int)-1).x;
        GridData data = new GridData(4, 4, true, false);
        data.minimumWidth = x;
        data.widthHint = x;
        toolBar.setLayoutData((Object)data);
        operatorSelectionToolItem.setText(this.getDisplayName(this.defaultOperator));
        operatorSelectionToolItem.setToolTipText(this.getDisplayName(this.defaultOperator));
        return operatorSelectionToolItem;
    }

    protected String getDisplayName(FilterExpression.Operator oper) {
        return oper.getDisplayName();
    }

    protected abstract void setOperator(FilterExpression.Operator var1);
}

