/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.model.FilterExpression;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ImageFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<String, Image> images = new HashMap<String, Image>();

    public static Image getImageFromURL(String aURLString) {
        try {
            Image result = images.get(aURLString);
            if (result == null) {
                result = ImageDescriptor.createFromURL((URL)new URL(aURLString)).createImage();
                images.put(aURLString, result);
            }
            return result;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static Image getConfigurationImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/transaction.gif");
    }

    public static Image getPackageImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/history.gif");
    }

    public static Image[] getFileDescriptorImage() {
        return null;
    }

    public static Image getErrorImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/error.gif");
    }

    public static Image getAddImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/add.gif");
    }

    public static Image getDeleteImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/delete.gif");
    }

    public static Image getDeleteImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/dlcl16/delete.gif");
    }

    public static Image getColumnImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/activity.gif");
    }

    public static Image getBlob() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/blob.gif");
    }

    public static Image getSearchHistoryImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/search_history.gif");
    }

    public static Image getSearchHistoryImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/dlcl16/search_history.gif");
    }

    public static Image getGroupsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/template_obj.gif");
    }

    public static Image getGroupsImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/dlcl16/templateprop_co.gif");
    }

    public static Image getGeneralImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/transaction.gif");
    }

    public static Image getFileImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/file.gif");
    }

    public static Image getFolderImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/fldr_obj.gif");
    }

    public static Image getSearchWizardBanner() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/wizban/newsearch_wiz.gif");
    }

    public static Image getFilterBanner() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/wizban/filter_wiz.gif");
    }

    public static Image getDateRangeBanner() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/wizban/report_window_wiz.gif");
    }

    public static Image getImageForOperator(FilterExpression.Operator operator) {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/" + operator.getIconImageName());
    }

    public static Image getChangePackageImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/change_package.gif");
    }

    public static Image getMigrationSchemeImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/migration_scheme.gif");
    }

    public static Image getApprovalProfileImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.cm.ui/icons/full/elcl16/approval_profile.gif");
    }
}

