/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.Messages;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DateRangeDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Date fromDate;
    private Date toDate;
    protected Calendar fromCalendar = Calendar.getInstance();
    private DateTime fromCalendarComposite;
    private DateTime fromDateComposite;
    private DateTime fromTimeComposite;
    private Button fromDateButton;
    private Date defaultDate;
    private Button toDateButton;
    private DateTime toCalendarComposite;
    private DateTime toDateComposite;
    private DateTime toTimeComposite;
    protected Calendar toCalendar = Calendar.getInstance();

    public DateRangeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("DateRangeDialog.title"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("DateRangeDialog.title"));
        this.setMessage(Messages.getString("DateRangeDialog.desc"));
        this.setTitleImage(ImageFactory.getDateRangeBanner());
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)gridLayout);
        Group fromGroup = new Group(mainComposite, 0);
        fromGroup.setText(Messages.getString("DateRangeDialog.label.from"));
        GridData data = new GridData(4, 4, true, true);
        gridLayout = new GridLayout(1, false);
        fromGroup.setLayout((Layout)gridLayout);
        fromGroup.setLayoutData((Object)data);
        final Button fromOldestButton = new Button((Composite)fromGroup, 16);
        fromOldestButton.setText(Messages.getString("DateRangeDialog.label.earliest"));
        fromOldestButton.setLayoutData((Object)data);
        this.fromDateButton = new Button((Composite)fromGroup, 16);
        this.fromDateButton.setText(Messages.getString("DateRangeDialog.label.date"));
        SelectionAdapter fromRadioButtonsListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == fromOldestButton) {
                    DateRangeDialog.this.fromDateButton.setSelection(false);
                    fromOldestButton.setSelection(true);
                    DateRangeDialog.this.disableFromDate(true);
                } else {
                    DateRangeDialog.this.fromDateButton.setSelection(true);
                    fromOldestButton.setSelection(false);
                    DateRangeDialog.this.disableFromDate(false);
                }
            }
        };
        fromOldestButton.addSelectionListener((SelectionListener)fromRadioButtonsListener);
        this.fromDateButton.addSelectionListener((SelectionListener)fromRadioButtonsListener);
        this.fromCalendarComposite = new DateTime((Composite)fromGroup, 3072);
        this.fromCalendarComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateRangeDialog.this.fromCalendar.set(1, DateRangeDialog.this.fromCalendarComposite.getYear());
                DateRangeDialog.this.fromCalendar.set(2, DateRangeDialog.this.fromCalendarComposite.getMonth());
                DateRangeDialog.this.fromCalendar.set(5, DateRangeDialog.this.fromCalendarComposite.getDay());
                DateRangeDialog.this.refresh(DateRangeDialog.this.fromCalendarComposite, DateRangeDialog.this.fromDateComposite, DateRangeDialog.this.fromTimeComposite, DateRangeDialog.this.fromCalendar);
            }
        });
        data = new GridData(4, 4, true, true);
        data.horizontalIndent = 20;
        this.fromCalendarComposite.setLayoutData((Object)data);
        Composite fromComposite = new Composite((Composite)fromGroup, 0);
        gridLayout = new GridLayout(2, false);
        fromComposite.setLayout((Layout)gridLayout);
        data = new GridData(4, 4, true, true);
        data.horizontalIndent = 20;
        fromComposite.setLayoutData((Object)data);
        this.fromDateComposite = new DateTime(fromComposite, 2080);
        this.fromDateComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateRangeDialog.this.fromCalendar.set(1, DateRangeDialog.this.fromDateComposite.getYear());
                DateRangeDialog.this.fromCalendar.set(2, DateRangeDialog.this.fromDateComposite.getMonth());
                DateRangeDialog.this.fromCalendar.set(5, DateRangeDialog.this.fromDateComposite.getDay());
                DateRangeDialog.this.refresh(DateRangeDialog.this.fromCalendarComposite, DateRangeDialog.this.fromDateComposite, DateRangeDialog.this.fromTimeComposite, DateRangeDialog.this.fromCalendar);
            }
        });
        this.fromTimeComposite = new DateTime(fromComposite, 2176);
        this.fromTimeComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateRangeDialog.this.fromCalendar.set(11, DateRangeDialog.this.fromTimeComposite.getHours());
                DateRangeDialog.this.fromCalendar.set(12, DateRangeDialog.this.fromTimeComposite.getMinutes());
                DateRangeDialog.this.fromCalendar.set(13, DateRangeDialog.this.fromTimeComposite.getSeconds());
                DateRangeDialog.this.refresh(DateRangeDialog.this.fromCalendarComposite, DateRangeDialog.this.fromDateComposite, DateRangeDialog.this.fromTimeComposite, DateRangeDialog.this.fromCalendar);
            }
        });
        if (this.fromDate != null) {
            this.fromDateButton.setSelection(true);
            fromOldestButton.setSelection(false);
            this.disableFromDate(false);
            this.refresh(this.fromCalendarComposite, this.fromDateComposite, this.fromTimeComposite, this.fromCalendar);
        } else {
            this.fromDateButton.setSelection(false);
            fromOldestButton.setSelection(true);
            this.disableFromDate(true);
        }
        Group toGroup = new Group(mainComposite, 0);
        toGroup.setText(Messages.getString("DateRangeDialog.label.to"));
        data = new GridData(4, 4, true, true);
        gridLayout = new GridLayout(1, false);
        toGroup.setLayout((Layout)gridLayout);
        toGroup.setLayoutData((Object)data);
        final Button toNewestButton = new Button((Composite)toGroup, 16);
        toNewestButton.setText(Messages.getString("DateRangeDialog.label.latest"));
        toNewestButton.setLayoutData((Object)data);
        this.toDateButton = new Button((Composite)toGroup, 16);
        this.toDateButton.setText(Messages.getString("DateRangeDialog.label.selectDate"));
        SelectionAdapter toRadioButtonsListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == toNewestButton) {
                    DateRangeDialog.this.toDateButton.setSelection(false);
                    toNewestButton.setSelection(true);
                    DateRangeDialog.this.disableToDate(true);
                } else {
                    DateRangeDialog.this.toDateButton.setSelection(true);
                    toNewestButton.setSelection(false);
                    DateRangeDialog.this.disableToDate(false);
                }
            }
        };
        toNewestButton.addSelectionListener((SelectionListener)toRadioButtonsListener);
        this.toDateButton.addSelectionListener((SelectionListener)toRadioButtonsListener);
        this.toCalendarComposite = new DateTime((Composite)toGroup, 3072);
        this.toCalendarComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateRangeDialog.this.toCalendar.set(1, DateRangeDialog.this.toCalendarComposite.getYear());
                DateRangeDialog.this.toCalendar.set(2, DateRangeDialog.this.toCalendarComposite.getMonth());
                DateRangeDialog.this.toCalendar.set(5, DateRangeDialog.this.toCalendarComposite.getDay());
                DateRangeDialog.this.refresh(DateRangeDialog.this.toCalendarComposite, DateRangeDialog.this.toDateComposite, DateRangeDialog.this.toTimeComposite, DateRangeDialog.this.toCalendar);
            }
        });
        data = new GridData(4, 4, true, true);
        data.horizontalIndent = 20;
        this.toCalendarComposite.setLayoutData((Object)data);
        Composite toComposite = new Composite((Composite)toGroup, 0);
        gridLayout = new GridLayout(2, false);
        toComposite.setLayout((Layout)gridLayout);
        data = new GridData(4, 4, true, true);
        data.horizontalIndent = 20;
        toComposite.setLayoutData((Object)data);
        this.toDateComposite = new DateTime(toComposite, 2080);
        this.toDateComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateRangeDialog.this.toCalendar.set(1, DateRangeDialog.this.toDateComposite.getYear());
                DateRangeDialog.this.toCalendar.set(2, DateRangeDialog.this.toDateComposite.getMonth());
                DateRangeDialog.this.toCalendar.set(5, DateRangeDialog.this.toDateComposite.getDay());
                DateRangeDialog.this.refresh(DateRangeDialog.this.toCalendarComposite, DateRangeDialog.this.toDateComposite, DateRangeDialog.this.toTimeComposite, DateRangeDialog.this.toCalendar);
            }
        });
        this.toTimeComposite = new DateTime(toComposite, 2176);
        this.toTimeComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateRangeDialog.this.toCalendar.set(11, DateRangeDialog.this.toTimeComposite.getHours());
                DateRangeDialog.this.toCalendar.set(12, DateRangeDialog.this.toTimeComposite.getMinutes());
                DateRangeDialog.this.toCalendar.set(13, DateRangeDialog.this.toTimeComposite.getSeconds());
                DateRangeDialog.this.refresh(DateRangeDialog.this.toCalendarComposite, DateRangeDialog.this.toDateComposite, DateRangeDialog.this.toTimeComposite, DateRangeDialog.this.toCalendar);
            }
        });
        if (this.toDate != null) {
            this.toDateButton.setSelection(true);
            toNewestButton.setSelection(false);
            this.disableToDate(false);
            this.refresh(this.toCalendarComposite, this.toDateComposite, this.toTimeComposite, this.toCalendar);
        } else {
            this.toDateButton.setSelection(false);
            toNewestButton.setSelection(true);
            this.disableToDate(true);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite.getShell(), "com.ibm.cics.cm.ui.view_history_daterange");
        return mainComposite;
    }

    protected void refresh(DateTime calendar, DateTime date, DateTime time, Calendar cal) {
        calendar.setDate(cal.get(1), cal.get(2), cal.get(5));
        time.setTime(cal.get(11), cal.get(12), cal.get(13));
        date.setDate(cal.get(1), cal.get(2), cal.get(5));
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
        if (fromDate != null) {
            this.fromCalendar.setTime(fromDate);
        }
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
        if (toDate != null) {
            this.toCalendar.setTime(toDate);
        }
    }

    protected void okPressed() {
        this.fromDate = this.fromDateButton.getSelection() ? this.fromCalendar.getTime() : null;
        this.toDate = this.toDateButton.getSelection() ? this.toCalendar.getTime() : null;
        super.okPressed();
    }

    private void disableFromDate(boolean disable) {
        this.fromCalendarComposite.setEnabled(!disable);
        this.fromDateComposite.setEnabled(!disable);
        this.fromTimeComposite.setEnabled(!disable);
        if (disable) {
            this.fromDateComposite.setBackground(Display.getCurrent().getSystemColor(34));
            this.fromDateComposite.setForeground(Display.getCurrent().getSystemColor(33));
            this.fromTimeComposite.setBackground(Display.getCurrent().getSystemColor(34));
            this.fromTimeComposite.setForeground(Display.getCurrent().getSystemColor(33));
        } else {
            this.fromDateComposite.setBackground(null);
            this.fromDateComposite.setForeground(null);
            this.fromTimeComposite.setBackground(null);
            this.fromTimeComposite.setForeground(null);
        }
    }

    private void disableToDate(boolean disable) {
        this.toCalendarComposite.setEnabled(!disable);
        this.toDateComposite.setEnabled(!disable);
        this.toDateComposite.setBackground(Display.getCurrent().getSystemColor(34));
        this.toTimeComposite.setEnabled(!disable);
        if (disable) {
            this.toDateComposite.setBackground(Display.getCurrent().getSystemColor(34));
            this.toDateComposite.setForeground(Display.getCurrent().getSystemColor(33));
            this.toTimeComposite.setBackground(Display.getCurrent().getSystemColor(34));
            this.toTimeComposite.setForeground(Display.getCurrent().getSystemColor(33));
        } else {
            this.toDateComposite.setBackground(null);
            this.toDateComposite.setForeground(null);
            this.toTimeComposite.setBackground(null);
            this.toTimeComposite.setForeground(null);
        }
    }
}

