/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.model.CMDefinition;
import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class ConfigurationsViewLabelProvider
extends CellLabelProvider
implements ILabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void update(ViewerCell cell) {
        TreeItem treeItem = (TreeItem)cell.getItem();
        treeItem.setText(0, this.getText(cell.getElement()));
        treeItem.setImage(0, this.getImage(cell.getElement()));
        if (cell.getElement() instanceof CMObject) {
            CMObject cmObject = (CMObject)cell.getElement();
            treeItem.setText(1, cmObject.getDescription());
        } else if (cell.getElement() instanceof CMDefinition) {
            CMDefinition configurationResource = (CMDefinition)cell.getElement();
            treeItem.setText(1, configurationResource.getDescription());
        }
    }

    public Image getImage(Object element) {
        if (element instanceof PendingUpdateAdapter) {
            return UIActivator.getBusyImage();
        }
        Image image = null;
        IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            image = UIActivator.getImage(adapter.getImageDescriptor(element));
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof PendingUpdateAdapter) {
            return Messages.getString("ConfigurationsViewLabelProvider.fetchingMessage");
        }
        IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            return adapter.getLabel(element);
        }
        return element.toString();
    }

    private IDeferredWorkbenchAdapter getAdapter(Object adaptable) {
        String adapterTypeName = IDeferredWorkbenchAdapter.class.getName();
        IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().loadAdapter(adaptable, adapterTypeName);
        return adapter;
    }
}

