/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Color;

public class ConfigurationConnectionDecorator
implements ILightweightLabelDecorator,
IColorDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.listeners.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ConfigurationConnection) {
            boolean acquired;
            ConfigurationConnection cc = (ConfigurationConnection)element;
            String applid = cc.getApplid();
            if (StringUtil.hasContent((String)applid)) {
                decoration.addSuffix(" (" + applid + ")");
            }
            String servStatus = (acquired = cc.isAcquired()) ? Messages.getString("ConfConn.acquired") : Messages.getString("ConfConn.released");
            boolean inService = cc.isInService();
            String connStatus = inService ? Messages.getString("ConfConn.inservice") : Messages.getString("ConfConn.outservice");
            decoration.addSuffix(" - " + servStatus + ", " + connStatus);
        }
    }

    public Color decorateForeground(Object element) {
        return null;
    }

    public Color decorateBackground(Object element) {
        return null;
    }
}

