/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.AbstractConnectionCustomizer;
import com.ibm.cics.core.connections.IConnectionCustomizerListener;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CMConnectionCustomizer
extends AbstractConnectionCustomizer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CMConnectionCustomizer.class.getPackage().getName());
    private ConnectionConfiguration connectionConfiguration;
    private Table table;
    private boolean synchronizingUIToModel = false;

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
        if (connectionConfiguration == null) {
            this.table.removeAll();
            return;
        }
        this.populateTable();
    }

    private void populateTable() {
        this.synchronizingUIToModel = true;
        try {
            String ourSMConnectionTypeID = this.connectionConfiguration.getExtendedAttribute("ID");
            String ourSMConnectionName = this.connectionConfiguration.getExtendedAttribute("NAME");
            String ourSMConnectionId = this.connectionConfiguration.getExtendedAttribute("SM_CONFIGURATION_ID");
            if (ourSMConnectionTypeID == null) {
                ourSMConnectionTypeID = UIActivator.getDefault().getPreferenceStore().getString(String.valueOf(this.connectionConfiguration.getName()) + "/" + "ID");
            }
            if (ourSMConnectionName == null) {
                ourSMConnectionName = UIActivator.getDefault().getPreferenceStore().getString(String.valueOf(this.connectionConfiguration.getName()) + "/" + "NAME");
            }
            this.table.removeAll();
            Map[] configurationsMapArray = this.getConnectionPreferencePage().getConfigurationsMap();
            Collection descriptors = this.getConnectionPreferencePage().getDescriptors();
            int index = 0;
            for (IConnectionDescriptor iConnectionDescriptor : descriptors) {
                String id = iConnectionDescriptor.getId();
                String categoryId = iConnectionDescriptor.getCategory().getId();
                if (!CMSMConnection.ID.equals(id) && categoryId.equals("com.ibm.cics.sm.connection")) {
                    String connectionName = iConnectionDescriptor.getName();
                    Map nameMap = configurationsMapArray[index];
                    for (Map.Entry entry : nameMap.entrySet()) {
                        String name = ((ConnectionConfiguration)entry.getValue()).getName();
                        TableItem connectionNameTableItem = new TableItem(this.table, 0);
                        connectionNameTableItem.setText(name);
                        connectionNameTableItem.setText(1, connectionName);
                        connectionNameTableItem.setData("ID", (Object)id);
                        connectionNameTableItem.setData("NAME", (Object)name);
                        connectionNameTableItem.setData("SM_CONFIGURATION_ID", (Object)((ConnectionConfiguration)entry.getValue()).getID());
                    }
                }
                ++index;
            }
            if (!this.selectByConnectionId(ourSMConnectionId) && !this.selectByTypeAndName(ourSMConnectionTypeID, ourSMConnectionName)) {
                this.connectionConfiguration.setExtendedAttribute("ID", "");
                this.connectionConfiguration.setExtendedAttribute("NAME", "");
            }
        }
        finally {
            this.synchronizingUIToModel = false;
        }
    }

    private boolean selectByConnectionId(String connectionId) {
        if (StringUtil.hasContent((String)connectionId)) {
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                if (connectionId.equals((String)tableItem.getData("SM_CONFIGURATION_ID"))) {
                    tableItem.setChecked(true);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean selectByTypeAndName(String ourSMConnectionTypeID, String ourSMConnectionName) {
        TableItem prospective = null;
        if (StringUtil.hasContent((String)ourSMConnectionName) && StringUtil.hasContent((String)ourSMConnectionTypeID)) {
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                String itemName = (String)tableItem.getData("NAME");
                String itemConnectionTypeId = (String)tableItem.getData("ID");
                if (ourSMConnectionName.equals(itemName) && ourSMConnectionTypeID.equals(itemConnectionTypeId)) {
                    if (prospective == null) {
                        prospective = tableItem;
                    } else {
                        return false;
                    }
                }
                ++n2;
            }
        }
        if (prospective != null) {
            prospective.setChecked(true);
            return true;
        }
        return false;
    }

    public void createControl(Composite parent) {
        this.table = new Table(parent, 2080);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        data.heightHint = 100;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setText(Messages.getString("CMConnectionCustomizer.columnHeading.name"));
        TableColumn typeColumn = new TableColumn(this.table, 0);
        typeColumn.setText(Messages.getString("CMConnectionCustomizer.columnHeading.type"));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        this.table.setLayout((Layout)tableLayout);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String smConnectionName;
                String smConnectionId;
                TableItem eventItem = (TableItem)e.item;
                if (eventItem.getChecked()) {
                    TableItem[] tableItems = CMConnectionCustomizer.this.table.getItems();
                    int i = 0;
                    while (i < tableItems.length) {
                        if (tableItems[i] != eventItem && tableItems[i].getChecked()) {
                            tableItems[i].setChecked(false);
                        }
                        ++i;
                    }
                    smConnectionId = (String)eventItem.getData("ID");
                    smConnectionName = (String)eventItem.getData("NAME");
                } else {
                    smConnectionId = "";
                    smConnectionName = "";
                }
                if (!CMConnectionCustomizer.this.synchronizingUIToModel) {
                    CMConnectionCustomizer.this.connectionConfiguration.setExtendedAttribute("ID", smConnectionId);
                    CMConnectionCustomizer.this.connectionConfiguration.setExtendedAttribute("NAME", smConnectionName);
                    for (IConnectionCustomizerListener listener : CMConnectionCustomizer.this.getListeners()) {
                        listener.propertyChanged((String)eventItem.getData("NAME"), (Object)eventItem.getChecked());
                    }
                }
            }
        });
    }

    public void updateCurrentConfiguration() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"updateCurrentConfiguration");
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (items[i].getChecked()) {
                TableItem tableItem = items[i];
                String smConnectionTypeId = (String)tableItem.getData("ID");
                String smConnectionName = (String)tableItem.getData("NAME");
                String smConnectionId = (String)tableItem.getData("SM_CONFIGURATION_ID");
                this.connectionConfiguration.setExtendedAttribute("ID", smConnectionTypeId);
                this.connectionConfiguration.setExtendedAttribute("NAME", smConnectionName);
                this.connectionConfiguration.setExtendedAttribute("SM_CONFIGURATION_ID", smConnectionId);
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"updateCurrentConfiguration");
                return;
            }
            ++i;
        }
        if (this.connectionConfiguration != null) {
            this.connectionConfiguration.setExtendedAttribute("ID", "");
            this.connectionConfiguration.setExtendedAttribute("NAME", "");
            this.connectionConfiguration.setExtendedAttribute("SM_CONFIGURATION_ID", "");
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"updateCurrentConfiguration");
    }

    public void clear() {
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (items[i].getChecked()) {
                items[i].setChecked(false);
            }
            ++i;
        }
    }

    public void performDefaults() {
        if (this.connectionConfiguration == null) {
            this.populateTable();
        }
    }

    public boolean performOk() {
        boolean performOk = super.performOk();
        UIActivator.getDefault().savePluginPreferences();
        return performOk;
    }
}

