/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.preferences;

import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.ProjectManager;
import com.ibm.cics.cm.ui.da.wizards.NewCMProjectWizard;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.editor.jcl.ZOSJCLMessages;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DAPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DAPreferencePage.class);
    private Text textControl1;
    private Button checkControl2;
    private Text textControl3;
    private SourceViewer jclView;

    protected Control createContents(Composite parent) {
        debug.enter("createContents");
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp(this.getControl(), "com.ibm.cics.cm.ui.da_preferences");
        this.createJCLText(parent);
        this.createFilterText(parent);
        this.createOpenEditorButton(parent);
        this.createProjectText(parent);
        debug.exit("createContents");
        return parent;
    }

    private void createJCLText(Composite parent) {
        debug.enter("createJCLText");
        Composite compo = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compo.setLayout((Layout)layout);
        compo.setLayoutData((Object)new GridData(768));
        this.jclView = new SourceViewer(compo, null, 2816);
        this.jclView.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.jclView.setDocument(this.getDocument());
        Control control = this.jclView.getControl();
        control.setLayoutData((Object)new GridData(768));
        this.jclView.getTextWidget().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        debug.exit("createJCLText");
    }

    private void createFilterText(Composite parent) {
        debug.enter("createFilterText");
        Composite compo = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compo.setLayout((Layout)layout);
        compo.setLayoutData((Object)new GridData(768));
        Label label = new Label(compo, 0);
        label.setText(Messages.getString("Preferences.Filter"));
        label.setToolTipText(Messages.getString("Preferences.Filter.tooltip"));
        label.setLayoutData((Object)new GridData());
        this.textControl1 = new Text(compo, 2052);
        TextInput.setAccessibleLabel((Text)this.textControl1, (Label)label);
        this.textControl1.setText(this.getPreferenceStore().getString("FILTER"));
        this.textControl1.setToolTipText(Messages.getString("Preferences.Filter.tooltip"));
        this.textControl1.setLayoutData((Object)new GridData(768));
        debug.exit("createFilterText");
    }

    private void createOpenEditorButton(Composite parent) {
        debug.enter("createOpenEditorButton");
        Composite compo = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compo.setLayout((Layout)layout);
        compo.setLayoutData((Object)new GridData(768));
        this.checkControl2 = new Button(compo, 32);
        this.checkControl2.setSelection(this.getPreferenceStore().getBoolean("EDITOR"));
        this.checkControl2.setText(Messages.getString("Preferences.CheckButton"));
        this.checkControl2.setToolTipText(Messages.getString("Preferences.CheckButton.tooltip"));
        this.checkControl2.setLayoutData((Object)new GridData());
        debug.exit("createOpenEditorButton");
    }

    private void createProjectText(Composite parent) {
        debug.enter("createProjectText");
        Composite compo = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compo.setLayout((Layout)layout);
        compo.setLayoutData((Object)new GridData(1808));
        Label label = new Label(compo, 0);
        label.setText(Messages.getString("Preferences.Project"));
        label.setToolTipText(Messages.getString("Preferences.Project.tooltip"));
        label.setLayoutData((Object)new GridData());
        this.textControl3 = new Text(compo, 2052);
        TextInput.setAccessibleLabel((Text)this.textControl3, (Label)label);
        this.textControl3.setText(this.getPreferenceStore().getString("PROJECT"));
        this.textControl3.setToolTipText(Messages.getString("Preferences.Project.tooltip"));
        this.textControl3.setEditable(false);
        this.textControl3.setLayoutData((Object)new GridData(768));
        Button button = new Button(compo, 8);
        button.setText(Messages.getString("Preferences.Project.button"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListDialog dialog = new ListDialog(DAPreferencePage.this.getShell());
                dialog.setTitle(Messages.getString("Preferences.Project.tooltip"));
                dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        if (element instanceof IProject) {
                            try {
                                if (((IProject)element).hasNature("com.ibm.cics.zos.ui.nature")) {
                                    if (((IProject)element).getFolder(ZOSJCLMessages.Folder_template).exists()) {
                                        return UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_DAWIZ);
                                    }
                                    return ZOSActivator.getImage((String)"IMG_JCL");
                                }
                            }
                            catch (CoreException e) {
                                debug.error("widgetSelected", (Throwable)e);
                            }
                        }
                        return null;
                    }

                    public String getText(Object element) {
                        if (element instanceof IProject) {
                            return ((IProject)element).getName();
                        }
                        return element.toString();
                    }
                });
                Collection<IProject> projects = ProjectManager.getDAProjects();
                Object[] selectedElements = new Object[projects.size() + 1];
                int counter = 0;
                selectedElements[counter] = Messages.getString("Preferences.NewProject");
                for (IProject project : projects) {
                    selectedElements[++counter] = project;
                }
                dialog.setContentProvider(new IStructuredContentProvider(){

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }

                    public void dispose() {
                    }

                    public Object[] getElements(Object inputElement) {
                        return (Object[])inputElement;
                    }
                });
                dialog.setInput((Object)selectedElements);
                dialog.setMessage(Messages.getString("Preferences.Message"));
                if (dialog.open() == 0) {
                    Object[] results = dialog.getResult();
                    if (results[0] instanceof IProject) {
                        DAPreferencePage.this.textControl3.setText(((IProject)results[0]).getName());
                    } else {
                        WizardDialog dialog1 = new WizardDialog(DAPreferencePage.this.getShell(), (IWizard)new NewCMProjectWizard());
                        dialog1.setBlockOnOpen(true);
                        dialog1.create();
                        if (dialog1.open() == 0) {
                            for (IProject project : ProjectManager.getDAProjects()) {
                                if (projects.contains(project)) continue;
                                DAPreferencePage.this.textControl3.setText(project.getName());
                            }
                        }
                    }
                }
            }
        });
        debug.exit("createProjectText");
    }

    private IDocument getDocument() {
        debug.enter("getDocument");
        Document doc = new Document(this.getPreferenceStore().getString("JOB_CARD"));
        debug.exit("getDocument", (Object)doc);
        return doc;
    }

    public void init(IWorkbench workbench) {
        debug.enter("init");
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), UIActivator.getDefault().getBundle().getSymbolicName()));
        this.setDescription(Messages.getString("Preferences.Description"));
        debug.exit("init");
    }

    public boolean performOk() {
        debug.enter("performOk");
        this.getPreferenceStore().setValue("JOB_CARD", this.jclView.getDocument().get());
        this.getPreferenceStore().setValue("FILTER", this.textControl1.getText());
        this.getPreferenceStore().setValue("EDITOR", this.checkControl2.getSelection());
        this.getPreferenceStore().setValue("PROJECT", this.textControl3.getText());
        debug.exit("performOk");
        return super.performOk();
    }

    protected void performDefaults() {
        debug.enter("performDefaults");
        this.textControl1.setText(this.getPreferenceStore().getDefaultString("FILTER"));
        this.checkControl2.setSelection(true);
        this.textControl3.setText(Messages.getString("NewProject_project_name"));
        this.jclView.setDocument((IDocument)new Document(this.getPreferenceStore().getDefaultString("JOB_CARD")));
        super.performDefaults();
        debug.exit("performDefaults");
    }
}

