/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.Configuration;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.cm.ui.da.model.Phase;
import java.text.MessageFormat;
import java.util.List;

public class Scope
extends DALabel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Phase phase;

    public Scope(String label, Phase phase) {
        super(label);
        this.phase = phase;
    }

    @Override
    public List<MarkerInformation> getErrors() {
        Configuration.ConfigurationType configType;
        List<MarkerInformation> errors = super.getErrors();
        if (this.getLabel() == null) {
            errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.NO_FIELD_VALUE"), this.jclParameter()), this.position));
        }
        if (this.phase != null && (configType = this.phase.getConfigurationTypeForPhase()) == Configuration.ConfigurationType.CSD) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.SCOPE_INVALID_IN_CONTEXT"), this.position));
        }
        return errors;
    }

    @Override
    protected String basicString() {
        return Messages.getString("Model.scope");
    }

    @Override
    protected String jclParameter() {
        return "SCOPE";
    }

    @Override
    protected String getXMLTag() {
        return "<SCOPE>{0}</SCOPE>";
    }
}

