/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class PhaseReportType
extends DALabel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ReportType type = null;

    public PhaseReportType(String type) {
        super(type);
        this.setPhaseReportType(type);
    }

    public ReportType getType() {
        return this.type;
    }

    public void setPhaseReportType(String type) {
        this.type = null;
        if (type.equals("COLDSTARTCOMPARE")) {
            this.type = ReportType.ColdStartCompare;
        } else if (type.equals("CANDIDATESCOMPARE")) {
            this.type = ReportType.CandidatesCompare;
        } else if (type.equals("RUNTIMECOMPARE")) {
            this.type = ReportType.RuntimeCompare;
        } else if (type.equals("CHECK")) {
            this.type = ReportType.Check;
        } else if (type.equals("CANDIDATES")) {
            this.type = ReportType.Candidates;
        } else if (type.equals("RUNTIME")) {
            this.type = ReportType.Runtime;
        }
    }

    @Override
    public List<MarkerInformation> getErrors() {
        ArrayList<MarkerInformation> errors = new ArrayList<MarkerInformation>();
        if (this.type == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.PHASETYPE_WRONG"), this.position));
        }
        return errors;
    }

    @Override
    public String toString() {
        return "TYPE=" + (this.type == null ? "" : this.type.name());
    }

    @Override
    public String toXMLTag() {
        return MessageFormat.format(this.getXMLTag(), this.getType().toString());
    }

    @Override
    protected String jclParameter() {
        return "TYPE";
    }

    @Override
    protected String getXMLTag() {
        return "<REPORTTYPE>{0}</REPORTTYPE>";
    }

    public static enum ReportType {
        ColdStartCompare("COLDSTARTCOMPARE", "Cold Start Compare", Messages.getString("Report.type.coldstart.desc"), Messages.getString("Report.type.coldstart.rs1desc"), Messages.getString("Report.type.coldstart.rs2desc"), true, false, false, true),
        CandidatesCompare("CANDIDATESCOMPARE", "Candidates Compare", Messages.getString("Report.type.candidates_comp.desc"), Messages.getString("Report.type.candidates_comp.rs1desc"), Messages.getString("Report.type.candidates_comp.rs2desc"), false, true, false, true),
        RuntimeCompare("RUNTIMECOMPARE", "Runtime Compare", Messages.getString("Report.type.runtime_comp.desc"), Messages.getString("Report.type.runtime_comp.rs1desc"), Messages.getString("Report.type.runtime_comp.rs2desc"), true, false, true, false),
        Runtime("RUNTIME", "Runtime", Messages.getString("Report.type.runtime.desc"), Messages.getString("Report.type.runtime.rs1desc"), null, true, false, false, false),
        Candidates("CANDIDATES", "Candidates", Messages.getString("Report.type.candidates.desc"), Messages.getString("Report.type.candidates.rs1desc"), null, false, true, false, false),
        Check("CHECK", "Check", Messages.getString("Report.type.check.desc"), Messages.getString("Report.type.check.rs1desc"), null, false, true, false, false);

        private String type;
        private String reportReadable;
        private String reportDescription;
        private String reportSet1Desc;
        private String reportSet2Desc;
        private boolean reportSet1RuntimesAllowed;
        private boolean reportSet1CandidatesAllowed;
        private boolean reportSet2RuntimesAllowed;
        private boolean reportSet2CandidatesAllowed;

        private ReportType(String type, String reportReadable, String reportDescription, String reportSet1Desc, String reportSet2Desc, boolean reportSet1RuntimesAllowed, boolean reportSet1CandidatesAllowed, boolean reportSet2RuntimesAllowed, boolean reportSet2CandidatesAllowed) {
            this.type = type;
            this.reportReadable = reportReadable;
            this.reportDescription = reportDescription;
            this.reportSet1Desc = reportSet1Desc;
            this.reportSet2Desc = reportSet2Desc;
            this.reportSet1RuntimesAllowed = reportSet1RuntimesAllowed;
            this.reportSet1CandidatesAllowed = reportSet1CandidatesAllowed;
            this.reportSet2RuntimesAllowed = reportSet2RuntimesAllowed;
            this.reportSet2CandidatesAllowed = reportSet2CandidatesAllowed;
        }

        public String toString() {
            return this.type;
        }

        public String getReportReadable() {
            return this.reportReadable;
        }

        public String getReportDescription() {
            return this.reportDescription;
        }

        public String getReportSet1Desc() {
            return this.reportSet1Desc;
        }

        public String getReportSet2Desc() {
            return this.reportSet2Desc;
        }

        public boolean isReportSet1RuntimesAllowed() {
            return this.reportSet1RuntimesAllowed;
        }

        public boolean isReportSet1CandidatesAllowed() {
            return this.reportSet1CandidatesAllowed;
        }

        public boolean isReportSet2RuntimesAllowed() {
            return this.reportSet2RuntimesAllowed;
        }

        public boolean isReportSet2CandidatesAllowed() {
            return this.reportSet2CandidatesAllowed;
        }
    }
}

