/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.Configuration;
import com.ibm.cics.cm.ui.da.model.Connection;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.FilterDataSet;
import com.ibm.cics.cm.ui.da.model.Group;
import com.ibm.cics.cm.ui.da.model.GrpList;
import com.ibm.cics.cm.ui.da.model.Localsysid;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.cm.ui.da.model.PhaseReportType;
import com.ibm.cics.cm.ui.da.model.ReportSetLabel;
import com.ibm.cics.cm.ui.da.model.Scope;
import com.ibm.cics.cm.utilities.ListeningArrayList;
import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.List;

public class Phase
extends DALabel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(Phase.class);
    private PhaseReportType type;
    private Stage stage;
    private List<DALabel> groupies;
    private Configuration configuration;
    private ReportSetLabel reportset;
    private FilterDataSet filterdsn;
    private Scope scope;
    private Localsysid localsysid;
    private Connection connection;

    public Phase(String label) {
        super(label);
        if (label.equals("COLLECT")) {
            this.setPhasetype(Stage.COLLECT);
        } else if (label.equals("REPORT")) {
            this.setPhasetype(Stage.REPORT);
        }
    }

    public FilterDataSet getFilterDSN() {
        return this.filterdsn;
    }

    public void setFilterDSN(FilterDataSet filterdsn) {
        this.filterdsn = filterdsn;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope1) {
        this.scope = scope1;
    }

    public PhaseReportType getReportType() {
        return this.type;
    }

    public void setPhaseReportType(PhaseReportType type) {
        this.type = type;
    }

    public List<DALabel> getGroupies() {
        if (this.groupies == null) {
            this.groupies = new ListeningArrayList();
        }
        return this.groupies;
    }

    public List<MarkerInformation> getGroupiesErrors() {
        ArrayList<MarkerInformation> errors = new ArrayList<MarkerInformation>();
        if (Stage.COLLECT == this.stage && this.type.getType() == PhaseReportType.ReportType.Candidates && this.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CSD && (this.groupies == null || this.groupies.isEmpty())) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_GROUPIES"), this.position));
        }
        return errors;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Configuration.ConfigurationType getConfigurationTypeForPhase() {
        if (this.configuration != null) {
            return this.configuration.getConfigurationType();
        }
        return Configuration.ConfigurationType.NO_CONFIGURATION;
    }

    public ReportSetLabel getReportset() {
        return this.reportset;
    }

    public void setReportset(ReportSetLabel reportset) {
        this.reportset = reportset;
    }

    public Stage getPhasetype() {
        return this.stage;
    }

    public void setPhasetype(Stage phasetype) {
        this.stage = phasetype;
    }

    @Override
    public List<MarkerInformation> getErrors() {
        List<MarkerInformation> groupiesErrors;
        debug.enter("getErrors");
        List<MarkerInformation> errors = super.getErrors();
        if (this.stage == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_PHASE"), this.position));
        }
        if (this.type == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_REPORT_TYPE"), this.position));
        } else {
            errors.addAll(this.type.getErrors());
        }
        if (Stage.COLLECT == this.stage && this.reportset == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_REPORT_SET"), this.position));
        }
        if (Stage.COLLECT == this.stage && this.configuration == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_CONFIGURATION"), this.position));
        }
        if (Stage.COLLECT == this.stage && this.type.getType() == PhaseReportType.ReportType.Runtime && this.getConfigurationTypeForPhase() != Configuration.ConfigurationType.CICSPlexSM && this.getConfigurationTypeForPhase() != Configuration.ConfigurationType.CSD && this.scope != null && this.connection != null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.CONNECTION_AND_SCOPE_SPECIFIED"), this.position));
        }
        if (!(Stage.COLLECT != this.stage || this.type.getType() != PhaseReportType.ReportType.Candidates || this.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CICSPlexSM || this.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CSD || this.scope == null || this.localsysid == null && this.getGroupies().isEmpty())) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.CSDOPTIONS_AND_SCOPE_SPECIFIED"), this.position));
        }
        if ((groupiesErrors = this.getGroupiesErrors()) != null && !groupiesErrors.isEmpty()) {
            errors.addAll(groupiesErrors);
        }
        for (DALabel group : this.getGroupies()) {
            errors.addAll(group.getErrors());
        }
        if (this.configuration != null) {
            errors.addAll(this.configuration.getErrors());
        }
        if (this.localsysid != null) {
            errors.addAll(this.localsysid.getErrors());
        }
        if (this.scope != null) {
            errors.addAll(this.scope.getErrors());
        }
        if (this.connection != null) {
            errors.addAll(this.connection.getErrors());
        }
        debug.exit("getErrors", errors);
        return errors;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("PHASE ");
        if (Stage.REPORT == this.stage) {
            buffer.append(Stage.REPORT.name());
            buffer.append(' ');
        } else if (Stage.COLLECT == this.stage) {
            buffer.append(Stage.COLLECT.name());
            buffer.append(' ');
            if (this.reportset != null) {
                buffer.append("REPORTSET " + this.reportset.getType().name());
                buffer.append(' ');
            }
        }
        if (this.filterdsn != null) {
            buffer.append(this.filterdsn.toString());
            buffer.append(' ');
        }
        if (this.configuration != null) {
            buffer.append(this.configuration.toString());
            buffer.append(' ');
        }
        if (this.type != null) {
            buffer.append(this.type.toString());
        }
        if (this.groupies != null) {
            for (DALabel conf : this.groupies) {
                buffer.append(conf.toString());
                buffer.append(' ');
            }
        }
        if (this.localsysid != null) {
            buffer.append(this.localsysid.toString());
            buffer.append(' ');
        }
        if (this.connection != null) {
            buffer.append(this.connection.toString());
            buffer.append(' ');
        }
        if (this.scope != null) {
            buffer.append(this.scope.toString());
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public void addGroup(Group group) {
        this.getGroupies().add(group);
    }

    public void addGrpList(GrpList group) {
        this.getGroupies().add(group);
    }

    public Localsysid getLocalSYSID() {
        return this.localsysid;
    }

    public void setLocalSYSID(Localsysid localsysid) {
        this.localsysid = localsysid;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public String toCCVPARMSString() {
        StringBuffer buffer = new StringBuffer("PHASE=");
        String indent = "                   ";
        if (Stage.REPORT == this.stage) {
            buffer.append(Stage.REPORT.name());
        } else if (Stage.COLLECT == this.stage) {
            buffer.append(Stage.COLLECT.name());
            if (this.reportset != null) {
                buffer.append(",\n");
                buffer.append(indent);
                buffer.append("REPORTSET=" + this.reportset.getType().toString());
            }
        }
        if (this.type != null) {
            buffer.append(",\n");
            buffer.append(indent);
            buffer.append(this.type.toCCVPARMSString());
        }
        if (this.filterdsn != null) {
            buffer.append(",\n");
            buffer.append(indent);
            buffer.append(this.filterdsn.toCCVPARMSString());
        }
        if (this.configuration != null) {
            buffer.append(",\n");
            buffer.append(indent);
            buffer.append(this.configuration.toCCVPARMSString());
        }
        if (this.groupies != null) {
            for (DALabel conf : this.groupies) {
                buffer.append(",\n");
                buffer.append(indent);
                buffer.append(conf.toCCVPARMSString());
            }
        }
        if (this.localsysid != null) {
            buffer.append(",\n");
            buffer.append(indent);
            buffer.append(this.localsysid.toCCVPARMSString());
        }
        if (this.connection != null) {
            buffer.append(",\n");
            buffer.append(indent);
            buffer.append(this.connection.toCCVPARMSString());
        }
        if (this.scope != null) {
            buffer.append(",\n");
            buffer.append(indent);
            buffer.append(this.scope.toCCVPARMSString());
        }
        return buffer.toString();
    }

    @Override
    protected String jclParameter() {
        return null;
    }

    @Override
    protected String getXMLTag() {
        return null;
    }

    public static enum Stage {
        COLLECT("COLLECT"),
        REPORT("REPORT");

        private String label;

        private Stage(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

