/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import java.util.List;

public class Configuration
extends DALabel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Configuration(String label) {
        super(label);
    }

    @Override
    protected String basicString() {
        return Messages.getString("Model.configuration");
    }

    @Override
    protected String jclParameter() {
        return "CONFIGURATION";
    }

    public ConfigurationType getConfigurationType() {
        CMConnection cmConnection = ConfigurationManager.getCurrent().getConnection();
        if (cmConnection != null && cmConnection.isConnected()) {
            com.ibm.cics.cm.model.Configuration configuration = ConfigurationManager.getCurrent().getCachedConfiguration(this.getLabel());
            if (configuration == null) {
                return ConfigurationType.UNKNOWN_CONFIGURATION;
            }
            if (configuration instanceof CPSMConfiguration) {
                return ConfigurationType.CICSPlexSM;
            }
            return ConfigurationType.CSD;
        }
        return ConfigurationType.NO_CM_CONNECTION;
    }

    @Override
    public List<MarkerInformation> getErrors() {
        List<MarkerInformation> errors = super.getErrors();
        ConfigurationType type = this.getConfigurationType();
        if (type == ConfigurationType.UNKNOWN_CONFIGURATION) {
            errors.add(new MarkerInformation(1, Messages.getString("Validation.UNKNOWN_CONFIGURATION"), this.position));
        }
        return errors;
    }

    @Override
    protected String getXMLTag() {
        return "<CCONFIG>{0}</CCONFIG>";
    }

    public static enum ConfigurationType {
        CICSPlexSM,
        CSD,
        NO_CM_CONNECTION,
        UNKNOWN_CONFIGURATION,
        NO_CONFIGURATION;

    }
}

