/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.handlers;

import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.ProjectManager;
import com.ibm.cics.cm.ui.da.dialogs.EditorSelectionDialog;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.builder.IResourceProcessor;
import com.ibm.cics.zos.ui.editor.jcl.JCLResourceEditor;
import com.ibm.cics.zos.ui.editor.jcl.JCLUtilities;
import com.ibm.cics.zos.ui.editor.jcl.SubmissableHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class EditorHandler
extends SubmissableHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(EditorHandler.class);

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        debug.enter("execute");
        this.workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IProject project = ProjectManager.getCurrentProject();
        if (project != null) {
            Object result;
            EditorSelectionDialog dialog = new EditorSelectionDialog(this.workbenchPart.getSite(), project);
            dialog.setInput(project);
            dialog.setTitle(Messages.getString("EditorDialog.DA"));
            dialog.setMessage(Messages.getString("EditorDialog.Message"));
            dialog.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_DAWIZ));
            dialog.setHelpAvailable(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.workbenchPart.getSite().getShell(), this.getHelpContextId());
            if (dialog.open() == 0 && (result = dialog.getFirstResult()) != null && result instanceof IFile) {
                IFile file = (IFile)result;
                if ("jct".equals(file.getFullPath().getFileExtension())) {
                    this.handleJCT(file.getName());
                } else if ("dar".equals(file.getFullPath().getFileExtension())) {
                    try {
                        this.workbenchPart.getSite().getPage().openEditor((IEditorInput)new FileEditorInput(file), "com.ibm.cics.cm.ui.da.dareportviewer");
                    }
                    catch (PartInitException e) {
                        debug.error("execute", (Throwable)e);
                    }
                } else {
                    this.openJCLEditor(file);
                }
            }
        }
        debug.exit("execute");
        return "";
    }

    private void handleJCT(String template) {
        StringBuffer buffer = ProjectManager.getTemplate(template, (ISelection)new StructuredSelection());
        if (buffer != null) {
            IFile file = ProjectManager.getNewFileName(template, "");
            try {
                if (!file.exists()) {
                    file.create(JCLUtilities.getInputStream((String)buffer.toString()), 1, null);
                } else {
                    file.setContents(JCLUtilities.getInputStream((String)buffer.toString()), 0, null);
                }
                for (IResourceProcessor processor : ZOSActivator.getDefault().getBuilders()) {
                    processor.process((IResource)file);
                }
                boolean openeditor = UIActivator.getDefault().getPreferenceStore().getBoolean("EDITOR");
                if (openeditor || file.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2) > 0) {
                    JCLResourceEditor editor = this.openJCLEditor(file);
                    editor.setTransient();
                } else {
                    EditorHandler.submit((String)buffer.toString(), (IWorkbenchPart)this.workbenchPart);
                    file.delete(true, null);
                }
            }
            catch (CoreException e) {
                debug.error("execute", (Throwable)e);
            }
        }
    }

    private JCLResourceEditor openJCLEditor(IFile file) {
        boolean da = false;
        try {
            FileEditorInput input;
            try {
                String line;
                BufferedReader buffered = new BufferedReader(new InputStreamReader(file.getContents()));
                boolean foundDeploy = false;
                while ((line = buffered.readLine()) != null) {
                    if (!foundDeploy && line.contains("DEPLOY")) {
                        foundDeploy = true;
                    }
                    if (!foundDeploy || !line.contains("TYPE=COLDSTARTCOMPARE") && !line.contains("TYPE=CHECK") && !line.contains("TYPE=RUNTIME") && !line.contains("TYPE=RUNTIMECOMPARE") && !line.contains("TYPE=CANDIDATES") && !line.contains("TYPE=CANDIDATESCOMPARE")) continue;
                    da = true;
                }
            }
            catch (CoreException e) {
                debug.error("execute", (Throwable)e);
            }
            catch (IOException e) {
                debug.error("execute", (Throwable)e);
            }
            if (da) {
                input = new FileEditorInput(file);
                file.setPersistentProperty(new QualifiedName("isDA", "isDA"), "true");
            } else {
                input = new FileEditorInput(file);
            }
            return (JCLResourceEditor)this.workbenchPart.getSite().getPage().openEditor((IEditorInput)input, "com.ibm.cics.jcl_editor");
        }
        catch (PartInitException e) {
            debug.error("execute", (Throwable)e);
        }
        catch (CoreException e) {
            debug.error("execute", (Throwable)e);
        }
        return null;
    }

    private String getHelpContextId() {
        return "com.ibm.cics.cm.ui.da_editor_dialog";
    }
}

