/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.core.ui.UIHelper;
import java.util.List;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;

public class ValidationUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static FocusListener getControlFocusValidationListener(final DALabel field) {
        return new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (e.widget instanceof Control) {
                    ValidationUtilities.validateControl((Control)e.widget, field.getErrors());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        };
    }

    public static void validateControl(Control control, List<MarkerInformation> markers) {
        String warnings = "";
        String errors = "";
        for (MarkerInformation mi : markers) {
            switch (mi.getSeverity()) {
                case 1: {
                    if (!warnings.isEmpty()) {
                        warnings = String.valueOf(warnings) + "\n";
                    }
                    warnings = String.valueOf(warnings) + mi.getMessage();
                    break;
                }
                case 2: {
                    if (!errors.isEmpty()) {
                        errors = String.valueOf(errors) + "\n";
                    }
                    errors = String.valueOf(errors) + mi.getMessage();
                    break;
                }
            }
        }
        UIHelper.clearError((Control)control);
        UIHelper.clearWarning((Control)control);
        if (!errors.isEmpty()) {
            UIHelper.errorControl((Control)control, (String)errors);
        } else if (!warnings.isEmpty()) {
            UIHelper.warningControl((Control)control, (String)warnings);
        }
    }
}

