/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.editors.DAJCLValidator;
import com.ibm.cics.cm.ui.da.editors.DAParmsValidator;
import com.ibm.cics.cm.ui.da.editors.DAScanner;
import com.ibm.cics.cm.ui.da.editors.ReportQueryEditorPage;
import com.ibm.cics.zos.ui.editor.jcl.ColorManager;
import com.ibm.cics.zos.ui.editor.jcl.JCLConfiguration;
import com.ibm.cics.zos.ui.editor.jcl.JCLResourceEditor;
import com.ibm.cics.zos.ui.editor.jcl.JCLTextEditor;
import com.ibm.cics.zos.ui.editor.jcl.JCLTextEditorConfigurator;
import com.ibm.cics.zos.ui.editor.jcl.Validator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.part.FileEditorInput;

public class TextEditorConfigurator
extends JCLTextEditorConfigurator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextSourceViewerConfiguration getTextSourceViewerConfiguration() {
        JCLConfiguration configurer = (JCLConfiguration)super.getTextSourceViewerConfiguration();
        ColorManager colorManager = configurer.getColorManager();
        DAScanner scanner = new DAScanner(colorManager);
        configurer.setDefaultTextScanner((ITokenScanner)scanner);
        return configurer;
    }

    public void addAdditionalValidators(JCLTextEditor editor) {
        editor.addValidator("__dftl_partition_content_type", (Validator)new DAParmsValidator("CCVBMAIN"));
        editor.addValidator("JCL_tag", (Validator)new DAJCLValidator());
    }

    public Map<String, IEditorPart> getPrependPages(JCLResourceEditor editor) {
        LinkedHashMap<String, IEditorPart> map = new LinkedHashMap<String, IEditorPart>();
        if (editor.getEditorInput() != null && editor.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput input = (FileEditorInput)editor.getEditorInput();
            try {
                if (input.getFile() != null && input.getFile().getPersistentProperty(new QualifiedName("isDA", "isDA")) != null) {
                    ReportQueryEditorPage rqEditor = new ReportQueryEditorPage(editor);
                    map.put(Messages.getString("ReportQueryEditor.title"), (IEditorPart)rqEditor);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return map;
    }
}

