/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.model.ReportSet;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.Report;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;

public class ReportSetViewerHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Report report;
    private static final String EMPTY_STRING = "";
    private static final String SPECIAL_TAG_CODE = "CODE";
    private static final String SPECIAL_TAG_DESCRIPTION = "DESC";

    public ReportSetViewerHelper(Report report) {
        this.report = report;
    }

    protected void createColumns(TableViewer viewer) {
        for (Map.Entry<Integer, ReportSet> e : this.report.getReportSets().entrySet()) {
            ReportSet rs = e.getValue();
            if (rs == null) continue;
            this.createColumn(viewer, MessageFormat.format(Messages.getString("ReportViewer.reportset.column.reportset"), rs.getId()), 85, true, true, null, rs);
        }
        this.createColumn(viewer, Messages.getString("ReportViewer.reportset.column.code"), 60, true, true, SPECIAL_TAG_CODE);
        this.createColumn(viewer, Messages.getString("ReportViewer.reportset.column.description"), 300, true, true, SPECIAL_TAG_DESCRIPTION);
    }

    private TableViewerColumn createColumn(TableViewer viewer, String name, int width, boolean resizable, boolean moveable, String attr) {
        return this.createColumn(viewer, name, width, resizable, moveable, attr, null);
    }

    private TableViewerColumn createColumn(TableViewer viewer, String name, int width, boolean resizable, boolean moveable, String attr, ReportSet rs) {
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText(name);
        col.getColumn().setWidth(width);
        col.getColumn().setResizable(resizable);
        col.getColumn().setMoveable(moveable);
        col.setLabelProvider((CellLabelProvider)new CustomColumnLabelProvider(attr, rs));
        return col;
    }

    private class CustomColumnLabelProvider
    extends ColumnLabelProvider {
        private String attribute;
        private ReportSet rs;

        public CustomColumnLabelProvider(String attribute, ReportSet rs) {
            this.attribute = attribute;
            this.rs = rs;
        }

        public String getText(Object element) {
            if (element instanceof ReportSet.Tags) {
                ReportSet.Tags t = (ReportSet.Tags)element;
                if (this.attribute == null) {
                    if (this.rs != null) {
                        String attr = (String)this.rs.getAttributes().get(t.toString());
                        if (attr == null) {
                            attr = "0";
                        }
                        return new Integer(attr).toString();
                    }
                } else {
                    if (this.attribute.equals(ReportSetViewerHelper.SPECIAL_TAG_CODE)) {
                        String code = t.getCode();
                        if (code == null) {
                            return ReportSetViewerHelper.EMPTY_STRING;
                        }
                        return code;
                    }
                    if (this.attribute.equals(ReportSetViewerHelper.SPECIAL_TAG_DESCRIPTION)) {
                        String description = t.getDescription();
                        if (description == null) {
                            return ReportSetViewerHelper.EMPTY_STRING;
                        }
                        return description;
                    }
                }
            }
            return ReportSetViewerHelper.EMPTY_STRING;
        }
    }

    protected class ReportSetContentProvider
    implements IStructuredContentProvider {
        protected ReportSetContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }
    }
}

