/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.model.DataSource;
import com.ibm.cics.cm.model.ReportItem;
import com.ibm.cics.cm.model.ReportItemAttribute;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.Report;
import com.ibm.cics.cm.ui.da.model.ReportCategories;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;

public class ReportItemViewerHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Report report;
    private static final String EMPTY_STRING = "";
    private static final String SPECIAL_TAG_REPORT_ITEM = "REPORT_ITEM";
    private static final String SPECIAL_TAG_CODE = "CODE";
    private static final String SPECIAL_TAG_CONDITION = "CONDITION";
    private static final String SPECIAL_TAG_COLLECTION_TYPE = "COLLECTION_TYPE";

    public ReportItemViewerHelper(Report report) {
        this.report = report;
    }

    protected void createColumns(TreeViewer viewer, ReportCategories.Catagories cat) {
        this.createColumn(viewer, EMPTY_STRING, 25, true, true, SPECIAL_TAG_REPORT_ITEM);
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.ID"), 25, true, true, ReportItem.Tags.ID.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.name"), 90, true, true, ReportItem.Tags.OBJNAME.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.type"), 90, true, true, ReportItem.Tags.OBJTYPE.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.group"), 90, true, true, ReportItem.Tags.OBJGROUP.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.list"), 90, true, true, ReportItem.Tags.RESDESC.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.code"), 60, true, true, SPECIAL_TAG_CODE);
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.condition"), 130, true, true, SPECIAL_TAG_CONDITION, cat);
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.local"), 80, true, true, ReportItem.Tags.LOCAL.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.enabled"), 90, true, true, ReportItem.Tags.ENABLED.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.vv"), 30, true, true, EMPTY_STRING);
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.checksum"), 90, true, true, ReportItem.Tags.CRC01.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.collection_type"), 130, true, true, SPECIAL_TAG_COLLECTION_TYPE);
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.rasgndef"), 85, true, true, EMPTY_STRING);
        this.createColumn(viewer, Messages.getString("ReportViewer.reportitem.column.group_seq"), 50, true, true, ReportItem.Tags.GRPSEQ.toString());
    }

    private TreeViewerColumn createColumn(TreeViewer viewer, String name, int width, boolean resizable, boolean moveable, String attr) {
        return this.createColumn(viewer, name, width, resizable, moveable, attr, null);
    }

    private TreeViewerColumn createColumn(TreeViewer viewer, String name, int width, boolean resizable, boolean moveable, String attr, ReportCategories.Catagories cat) {
        TreeViewerColumn col = new TreeViewerColumn(viewer, 0);
        col.getColumn().setText(name);
        col.getColumn().setWidth(width);
        col.getColumn().setResizable(resizable);
        col.getColumn().setMoveable(moveable);
        col.setLabelProvider((CellLabelProvider)new CustomColumnLabelProvider(attr, cat));
        return col;
    }

    private class CustomColumnLabelProvider
    extends ColumnLabelProvider {
        private String attribute;
        private ReportCategories.Catagories cat;

        public CustomColumnLabelProvider(String attribute, ReportCategories.Catagories cat) {
            this.attribute = attribute;
            this.cat = cat;
        }

        public String getText(Object element) {
            ReportItem item;
            if (element instanceof ReportItem && this.attribute != null) {
                String value;
                item = (ReportItem)element;
                HashMap attr = item.getAttributes();
                if (this.attribute.equals(ReportItemViewerHelper.SPECIAL_TAG_REPORT_ITEM)) {
                    return ReportItemViewerHelper.EMPTY_STRING;
                }
                if (this.attribute.equals(ReportItemViewerHelper.EMPTY_STRING)) {
                    return ReportItemViewerHelper.EMPTY_STRING;
                }
                if (this.attribute.equals(ReportItemViewerHelper.SPECIAL_TAG_CODE)) {
                    return String.valueOf((String)attr.get(ReportItem.Tags.CLASSIFICATION.toString())) + (String)attr.get(ReportItem.Tags.SUBCLASSIFICATION.toString());
                }
                if (this.attribute.equals(ReportItemViewerHelper.SPECIAL_TAG_COLLECTION_TYPE)) {
                    return DataSource.getCollectionType((String)((String)ReportItemViewerHelper.this.report.getDataSources().get(item.getId()).getAttributes().get(DataSource.Tags.TYPE.toString())));
                }
                if (this.attribute.equals(ReportItemViewerHelper.SPECIAL_TAG_CONDITION)) {
                    String classCode = String.valueOf((String)attr.get(ReportItem.Tags.CLASSIFICATION.toString())) + (String)attr.get(ReportItem.Tags.SUBCLASSIFICATION.toString());
                    if (!classCode.startsWith("09")) {
                        if (this.cat != null) {
                            return this.cat.getCodeShort(classCode);
                        }
                    } else {
                        HashMap verAttr;
                        ReportItem.ReportVerify ver = item.getReportVerify();
                        if (ver != null && (verAttr = ver.getAttributes()) != null) {
                            String msgid = (String)verAttr.get(ReportItem.Tags.MSGID.toString());
                            if (msgid != null) {
                                return msgid;
                            }
                            return ReportItemViewerHelper.EMPTY_STRING;
                        }
                    }
                }
                if (this.attribute.equals(ReportItem.Tags.LOCAL.toString())) {
                    String local = (String)attr.get(this.attribute);
                    if (local.equals("YES")) {
                        return Messages.getString("ReportViewer.reportitem.value.local");
                    }
                    if (local.equals("NO")) {
                        return Messages.getString("ReportViewer.reportitem.value.remote");
                    }
                    return local;
                }
                if (this.attribute.equals(ReportItem.Tags.ENABLED.toString())) {
                    String enabled = (String)attr.get(this.attribute);
                    if (enabled.equals("YES")) {
                        return Messages.getString("ReportViewer.reportitem.value.enabled");
                    }
                    if (enabled.equals("NO")) {
                        return Messages.getString("ReportViewer.reportitem.value.disabled");
                    }
                    return enabled;
                }
                if (this.attribute.equals(ReportItem.Tags.GRPSEQ.toString())) {
                    value = (String)attr.get(this.attribute);
                    if (value != null) {
                        return new Integer(value).toString();
                    }
                    return ReportItemViewerHelper.EMPTY_STRING;
                }
                value = (String)attr.get(this.attribute);
                if (value != null) {
                    return value;
                }
            }
            if (element instanceof ReportItemAttribute) {
                item = (ReportItemAttribute)element;
                if (this.attribute.equals(ReportItem.Tags.OBJNAME.toString())) {
                    return Messages.getString("ReportViewer.attribute");
                }
                if (this.attribute.equals(ReportItem.Tags.OBJTYPE.toString())) {
                    return item.getAttribute();
                }
                if (this.attribute.equals(ReportItem.Tags.OBJGROUP.toString())) {
                    return Messages.getString("ReportViewer.value");
                }
                if (this.attribute.equals(ReportItem.Tags.RESDESC.toString())) {
                    return item.getValue();
                }
            }
            return ReportItemViewerHelper.EMPTY_STRING;
        }
    }

    protected class ReportItemContentProvider
    implements ITreeContentProvider {
        protected ReportItemContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ReportItem) {
                ReportItem item = (ReportItem)parentElement;
                ReportItem.ReportVerify ver = item.getReportVerify();
                ReportItem.ReportDifferences diff = item.getReportDifferences();
                if (ver != null && ver.getAttributes().size() > 0 || diff != null && diff.getAttributes().size() > 0) {
                    String key;
                    LinkedHashMap attr = new LinkedHashMap();
                    if (ver != null) {
                        attr.putAll(ver.getAttributes());
                    }
                    if (diff != null) {
                        attr.putAll(diff.getAttributes());
                    }
                    ArrayList<ReportItemAttribute> children = new ArrayList<ReportItemAttribute>();
                    int i = 0;
                    while ((key = (String)attr.get(String.valueOf(ReportItem.Tags.ATTR.toString()) + i)) != null) {
                        String value = (String)attr.get(String.valueOf(ReportItem.Tags.VALUE.toString()) + i);
                        if (value != null) {
                            children.add(new ReportItemAttribute(key, value));
                        }
                        ++i;
                    }
                    return children.toArray();
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ReportItem) {
                ReportItem item = (ReportItem)element;
                ReportItem.ReportVerify ver = item.getReportVerify();
                ReportItem.ReportDifferences diff = item.getReportDifferences();
                if (ver != null && ver.getAttributes().size() > 0 || diff != null && diff.getAttributes().size() > 0) {
                    return true;
                }
            }
            return false;
        }
    }
}

