/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.editor.jcl.ColorManager;
import com.ibm.cics.zos.ui.editor.jcl.DefaultDetector;
import com.ibm.cics.zos.ui.editor.jcl.JCLColorConstants;
import com.ibm.cics.zos.ui.editor.jcl.Reloadable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public class DAScanner
extends RuleBasedScanner
implements Reloadable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DAScanner.class);
    private final String[] level0 = new String[]{"CONNECT", "DEPLOY", "READY"};
    private final String[] level1 = new String[]{"IPADDRESS", "PHASE", "TYPE", "SCOPE", "CONFIGURATION", "CONNECTION", "SSL", "PORT", "REPORTSET", "FILTERDATASET", "GROUP", "GRPLIST", "LOCALSYSID", "CPID", "SCHEME"};
    private final String[] level2 = new String[]{"RUNTIME", "REPORT", "COLDSTARTCOMPARE", "CANDIDATESCOMPARE", "RUNTIMECOMPARE", "CANDIDATES", "CHECK", "COLLECT"};
    private WordRule wr;
    private ColorManager manager;
    private Map<String, Token> tokenMap = new HashMap<String, Token>();

    public DAScanner(ColorManager manager) {
        debug.enter("JCLPartitionScanner");
        this.manager = manager;
        this.load();
        debug.exit("DAScanner");
    }

    public void load() {
        String word;
        ArrayList<Object> ruleBucket = new ArrayList<Object>();
        String[] stringArray = JCLColorConstants.KEYWORDS;
        int n = JCLColorConstants.KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            Boolean italic = Platform.getPreferencesService().getBoolean(ZOSActivator.getDefault().getBundle().getSymbolicName(), String.valueOf(keyword) + "_italic", false, null);
            Boolean bold = Platform.getPreferencesService().getBoolean(ZOSActivator.getDefault().getBundle().getSymbolicName(), String.valueOf(keyword) + "_bold", false, null);
            int style = (italic != false ? 2 : 0) | (bold != false ? 1 : 0);
            this.tokenMap.put(keyword, new Token((Object)new TextAttribute(this.manager.getColor(keyword), null, style)));
            ++n2;
        }
        this.setDefaultReturnToken((IToken)this.tokenMap.get("default"));
        this.wr = new WordRule((IWordDetector)new DefaultDetector());
        stringArray = this.level0;
        n = this.level0.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.wr.addWord(word, (IToken)this.tokenMap.get("keyword0"));
            ++n2;
        }
        stringArray = this.level1;
        n = this.level1.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.wr.addWord(word, (IToken)this.tokenMap.get("keyword1"));
            ++n2;
        }
        stringArray = this.level2;
        n = this.level2.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.wr.addWord(word, (IToken)this.tokenMap.get("keyword2"));
            ++n2;
        }
        ruleBucket.add(this.wr);
        ruleBucket.add(new EndOfLineRule(" * ", (IToken)this.tokenMap.get("comment")));
        ruleBucket.add(new EndOfLineRule("/*", (IToken)this.tokenMap.get("comment")));
        ruleBucket.add(new SingleLineRule("<", ">", (IToken)this.tokenMap.get("comment")));
        this.setRules(ruleBucket.toArray(new IRule[ruleBucket.size()]));
    }

    public void reload(PropertyChangeEvent event) {
        String key = event.getProperty();
        String[] stringArray = JCLColorConstants.KEYWORDS;
        int n = JCLColorConstants.KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (key.startsWith(keyword)) {
                int style = ((TextAttribute)this.tokenMap.get(keyword).getData()).getStyle();
                if (key.equals(String.valueOf(keyword) + "_italic")) {
                    style = event.getNewValue() == Boolean.TRUE ? (style |= 2) : (style &= 1);
                } else if (key.equals(String.valueOf(keyword) + "_bold")) {
                    style = event.getNewValue() == Boolean.TRUE ? (style |= 1) : (style &= 2);
                }
                this.tokenMap.get(keyword).setData((Object)new TextAttribute(this.manager.getColor(keyword), null, style));
            }
            ++n2;
        }
    }
}

