/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.zos.ui.editor.jcl.Validator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DAJCLValidator
implements Validator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DA_JCL_PROBLEM_MARKER = "com.ibm.cics.cm.ui.dajclproblem";
    private static final Debug debug = new Debug(DAJCLValidator.class);
    private List<MarkerInformation> errors;
    private IDocument document;

    public Validator intialise(IDocument document, IFile file) {
        try {
            file.deleteMarkers(DA_JCL_PROBLEM_MARKER, false, 0);
        }
        catch (CoreException e) {
            debug.error("intialise", (Throwable)e);
        }
        this.document = document;
        this.errors = new ArrayList<MarkerInformation>();
        return this;
    }

    public void processRegion(int offset, int length) {
        try {
            String text = this.document.get(offset, length);
            int invalidIndex = text.indexOf("nnnnnn");
            if (invalidIndex > -1) {
                this.errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.TEMPLATE_CHARACTERS"), "nnnnnn"), offset + invalidIndex));
            }
            if ((invalidIndex = text.indexOf("ccv.")) > -1) {
                this.errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.TEMPLATE_CHARACTERS"), "ccv"), offset + invalidIndex));
            }
            if ((invalidIndex = text.indexOf("lang")) > -1) {
                this.errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.TEMPLATE_CHARACTERS"), "lang"), offset + invalidIndex));
            }
        }
        catch (BadLocationException e) {
            debug.error("processRegion", (Throwable)e);
            return;
        }
    }

    public List<IMarker> stop(IFile file) {
        ArrayList<IMarker> results = new ArrayList<IMarker>();
        if (this.errors != null) {
            for (MarkerInformation info : this.errors) {
                try {
                    results.add(this.createMarker(file, info.getMessage(), this.document.getLineOfOffset(info.getDisplacement()) + 1, info.getSeverity()));
                }
                catch (BadLocationException e) {
                    try {
                        results.add(this.createMarker(file, info.getMessage(), 1, info.getSeverity()));
                    }
                    catch (CoreException e2) {
                        debug.error("stop", (Throwable)e2);
                    }
                }
                catch (CoreException e) {
                    debug.error("stop", (Throwable)e);
                }
            }
        }
        return results;
    }

    private IMarker createMarker(IFile file, String message, int line, int severity) throws CoreException {
        IMarker m = file.createMarker(DA_JCL_PROBLEM_MARKER);
        m.setAttribute("lineNumber", line);
        m.setAttribute("message", (Object)message);
        m.setAttribute("priority", 2);
        m.setAttribute("severity", severity);
        return m;
    }

    public String explicitProgramName() {
        return "CCVBMAIN";
    }
}

