/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.composites;

import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.editors.ValidationUtilities;
import com.ibm.cics.cm.ui.da.model.Configuration;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.utilities.ConfigurationContentProposalProvider;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.editors.wizards.LazyContentAssistCommandAdapter;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConfigurationComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String HAS_CONTENT_ASSIST = "HAS_CONTENT_ASSIST";
    private Text text;
    private Button cpsmRadio;
    private Button csdRadio;
    private List<ConfigurationCompositeListener> listeners = new ArrayList<ConfigurationCompositeListener>();

    public ConfigurationComposite(final Composite parent, int style, FormToolkit toolkit, final Phase phase) {
        Label label = toolkit.createLabel(parent, Messages.getString("ReportQueryEditor.field.CONFIGURATION"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Utilities.addMandatoryField((Control)label);
        TextInput input = new TextInput(parent, label);
        input.setLayoutData((Object)new GridData(16384, -1, false, false));
        input.setNumberOfCharacters(12);
        this.text = input.text;
        this.text.setTextLimit(8);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                if (((Boolean)ConfigurationComposite.this.text.getData(ConfigurationComposite.HAS_CONTENT_ASSIST)).booleanValue()) {
                    super.getName(event);
                    event.result = String.valueOf(event.result) + com.ibm.cics.cm.ui.Messages.getString((String)"ACCESSIBILITY.fieldHasContentAssist");
                }
            }
        });
        this.text.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.text.addFocusListener(ValidationUtilities.getControlFocusValidationListener(phase.getConfiguration()));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget instanceof Text) {
                    Text config = (Text)e.widget;
                    if (phase != null) {
                        String configString;
                        if (phase.getConfiguration() == null) {
                            phase.setConfiguration(new Configuration(""));
                        }
                        if ((configString = config.getText()) != null && !configString.trim().isEmpty()) {
                            phase.getConfiguration().setLabel(configString);
                        } else {
                            phase.getConfiguration().setLabel("<Config-name for a CSD file>");
                        }
                        if (phase.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CSD) {
                            ConfigurationComposite.this.csdRadio.setSelection(true);
                            ConfigurationComposite.this.cpsmRadio.setSelection(false);
                            ConfigurationComposite.this.cpsmRadio.setEnabled(false);
                            ConfigurationComposite.this.csdRadio.setEnabled(false);
                        } else if (phase.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CICSPlexSM) {
                            ConfigurationComposite.this.cpsmRadio.setSelection(true);
                            ConfigurationComposite.this.csdRadio.setSelection(false);
                            ConfigurationComposite.this.cpsmRadio.setEnabled(false);
                            ConfigurationComposite.this.csdRadio.setEnabled(false);
                        } else if (phase.getGroupies() != null && !phase.getGroupies().isEmpty() || phase.getConnection() != null && !phase.getConnection().getLabel().isEmpty() || phase.getLocalSYSID() != null && !phase.getLocalSYSID().getLabel().isEmpty() && (phase.getScope() == null || phase.getScope().getLabel().isEmpty())) {
                            ConfigurationComposite.this.csdRadio.setSelection(true);
                            ConfigurationComposite.this.cpsmRadio.setSelection(false);
                            ConfigurationComposite.this.cpsmRadio.setEnabled(true);
                            ConfigurationComposite.this.csdRadio.setEnabled(true);
                        } else if ((phase.getGroupies() == null || phase.getGroupies().isEmpty() || phase.getLocalSYSID() == null || phase.getLocalSYSID().getLabel().isEmpty()) && phase.getScope() != null && !phase.getScope().getLabel().isEmpty()) {
                            ConfigurationComposite.this.cpsmRadio.setSelection(true);
                            ConfigurationComposite.this.csdRadio.setSelection(false);
                            ConfigurationComposite.this.cpsmRadio.setEnabled(true);
                            ConfigurationComposite.this.csdRadio.setEnabled(true);
                        } else {
                            ConfigurationComposite.this.cpsmRadio.setEnabled(true);
                            ConfigurationComposite.this.csdRadio.setEnabled(true);
                        }
                        ConfigurationComposite.this.notifyListeners(true);
                    }
                }
            }
        });
        ConfigurationContentProposalProvider contentProposalProvider = new ConfigurationContentProposalProvider();
        TextContentAdapter textContentAdapter = new TextContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                super.insertControlContents(control, text, cursorPosition);
            }
        };
        LabelProvider connectionLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((IContentProposal)element).getLabel();
            }
        };
        final LazyContentAssistCommandAdapter contentProposalAdapter = new LazyContentAssistCommandAdapter((Control)this.text, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)contentProposalProvider, null, null, true);
        contentProposalAdapter.setProposalAcceptanceStyle(2);
        contentProposalProvider.addListener(new ConfigurationContentProposalProvider.Listener(){

            public void dataAvailable() {
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        contentProposalAdapter.updatePopupContents();
                    }
                });
            }
        });
        contentProposalAdapter.setLabelProvider((ILabelProvider)connectionLabelProvider);
        contentProposalAdapter.setEnabled(true);
        this.text.setData(HAS_CONTENT_ASSIST, (Object)Boolean.TRUE);
        Composite blank = toolkit.createComposite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        blank.setLayout((Layout)gl);
        blank.setLayoutData((Object)new GridData(-1, -1, false, false));
        Composite options = toolkit.createComposite(parent, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        options.setLayout((Layout)gl);
        options.setLayoutData((Object)new GridData(4, -1, true, false));
        this.cpsmRadio = toolkit.createButton(options, "CICSPlexSM", 16);
        this.cpsmRadio.setLayoutData((Object)new GridData(16384, -1, false, false));
        this.csdRadio = toolkit.createButton(options, "CSD", 16);
        this.csdRadio.setLayoutData((Object)new GridData(16384, -1, false, false));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationComposite.this.notifyListeners(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.cpsmRadio.addSelectionListener(selectionListener);
        this.csdRadio.addSelectionListener(selectionListener);
    }

    public Text getText() {
        return this.text;
    }

    public Button getCPSMRadio() {
        return this.cpsmRadio;
    }

    public Button getCSDRadio() {
        return this.csdRadio;
    }

    public boolean addListener(ConfigurationCompositeListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ConfigurationCompositeListener arrayListListener) {
        return this.listeners.remove(arrayListListener);
    }

    private void notifyListeners(boolean changed) {
        for (ConfigurationCompositeListener next : this.listeners) {
            next.notify(changed, next);
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public abstract class ConfigurationCompositeListener {
        private ConfigurationComposite host;

        public ConfigurationCompositeListener(ConfigurationComposite next) {
            this.host = next;
        }

        public abstract void notify(boolean var1, ConfigurationCompositeListener var2);

        public void dispose() {
            this.host.removeListener(this);
        }
    }
}

