/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.composites;

import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.composites.ConfigurationComposite;
import com.ibm.cics.cm.ui.da.editors.ValidationUtilities;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.ui.da.model.Scope;
import com.ibm.cics.cm.ui.widgets.CPSMScopeTextInput;
import com.ibm.cics.cm.utilities.Utilities;
import java.util.HashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CPSMOptions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Phase phase;
    private CPSMScopeTextInput scopeInput;

    public CPSMOptions(Composite parent, FormToolkit toolkit, Phase pPhase, HashMap<Control, String> controls, ConfigurationComposite configurationComposite) {
        String scope;
        this.phase = pPhase;
        Label scopeLabel = toolkit.createLabel(parent, Messages.getString("ReportQueryEditor.field.SCOPE"));
        controls.put((Control)scopeLabel, "cpsm");
        Utilities.addMandatoryField((Control)scopeLabel);
        this.scopeInput = new CPSMScopeTextInput(parent, scopeLabel);
        controls.put((Control)this.scopeInput, "cpsm");
        this.scopeInput.setLayoutData((Object)new GridData(16384, -1, false, false));
        Text scopeText = this.scopeInput.text;
        scopeText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        scopeText.addFocusListener(ValidationUtilities.getControlFocusValidationListener(this.phase.getScope()));
        scopeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget instanceof Text) {
                    Text scope = (Text)e.widget;
                    if (CPSMOptions.this.phase != null) {
                        String scopeString;
                        if (CPSMOptions.this.phase.getScope() == null) {
                            CPSMOptions.this.phase.setScope(new Scope("", CPSMOptions.this.phase));
                        }
                        if ((scopeString = scope.getText()) != null && !scopeString.trim().isEmpty()) {
                            CPSMOptions.this.phase.getScope().setLabel(scopeString);
                        } else {
                            CPSMOptions.this.phase.getScope().setLabel("<CICS region to be used as scope>");
                        }
                    }
                }
            }
        });
        scopeText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CPSMOptions.this.phase.getScope() == null || CPSMOptions.this.phase.getScope().getLabel().trim().isEmpty() || CPSMOptions.this.phase.getScope().getLabel().equals("<CICS region to be used as scope>")) {
                    CPSMOptions.this.phase.setScope(null);
                }
            }
        });
        if (this.phase != null && this.phase.getScope() != null && (scope = this.phase.getScope().getLabel()) != null && !scope.isEmpty()) {
            if (!scope.contains("<") || !scope.contains(">")) {
                scopeText.setText(scope);
            } else {
                scopeText.setText("");
            }
        }
    }

    public CPSMScopeTextInput getScopeInput() {
        return this.scopeInput;
    }
}

