/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.builder;

import com.ibm.cics.cm.ui.da.editors.DAJCLValidator;
import com.ibm.cics.cm.ui.da.editors.DAParmsValidator;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.zos.ui.builder.IResourceProcessor;
import com.ibm.cics.zos.ui.editor.jcl.JCLPartitionTokenScanner;
import com.ibm.cics.zos.ui.editor.jcl.JCLUtilities;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;

public class DAResourceProcessor
implements IResourceProcessor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DAResourceProcessor.class);
    private FileDocumentProvider jclDocProvider;

    public void process(IResource resource) {
        if (resource instanceof IFile && "jcl".equalsIgnoreCase(((IFile)resource).getFileExtension())) {
            this.validateJCLFile((IFile)resource);
        }
    }

    private void validateJCLFile(IFile file) {
        FileDocumentProvider provider = this.getJCLDocumentProvider();
        FileEditorInput input = new FileEditorInput(file);
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e1) {
            debug.error("validateFile", (Throwable)e1);
            return;
        }
        IDocument document = provider.getDocument((Object)input);
        HashMap<String, Object> validators = new HashMap<String, Object>();
        validators.put("JCL_tag", new DAJCLValidator());
        validators.put("__dftl_partition_content_type", new DAParmsValidator("CCVBMAIN"));
        JCLUtilities.validateJCLFile((IFile)file, (IDocument)document, validators);
    }

    private FileDocumentProvider getJCLDocumentProvider() {
        if (this.jclDocProvider == null) {
            this.jclDocProvider = new FileDocumentProvider(){

                protected IDocument createDocument(Object element) throws CoreException {
                    IDocument document = super.createDocument(element);
                    if (document != null) {
                        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new JCLPartitionTokenScanner(), new String[]{"JCL_comment", "JCL_tag", "__dftl_partition_content_type"});
                        partitioner.connect(document);
                        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
                    }
                    return document;
                }
            };
        }
        return this.jclDocProvider;
    }
}

