/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.zos.ui.editor.jcl.JCLUtilities;
import com.ibm.cics.zos.ui.editor.jcl.ZOSJCLMessages;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ProjectManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ProjectManager.class);
    public static final String overall = "Complete_template.jct";
    public static final String canCSD = "Candidates CSD.jct";
    public static final String checkCSD = "Check CSD.jct";
    public static final String canCPSM = "Candidates CPSM.jct";
    public static final String oldCanComp = "Candidates compare.jct";
    public static final String canCompCPSM = "Candidates compare CPSM.jct";
    public static final String canCompCSD = "Candidates compare CSD.jct";
    public static final String oldcold1 = "Runtime coldstart compare.jct";
    public static final String cold1 = "Runtime cold start compare.jct";
    public static final String runCPSM = "Runtime CPSM.jct";
    public static final String runCSD = "Runtime CSD.jct";
    public static final String runComp = "Runtime compare.jct";
    public static final String substitute_CSDConfiguration = "<Config-name for a CSD file>";
    public static final String substitute_CPSMConfiguration = "<Config-name for a CPSM context>";
    public static final String substitute_IManagedRegion = "<CICS region to be used as scope>";
    public static final String substitute_IRegion = "<CICS region to be used as scope>";
    public static final String substitute_GrpList = "<CSD-List name>";
    public static final String substitute_LocalSysID = "<CICS sysid evaluated as local>";
    public static final String substitute_Connection = "<Connection used by the CICS CM server>";
    static final String[] files = new String[]{"Complete_template.jct", "Candidates CSD.jct", "Candidates CPSM.jct", "Candidates compare CPSM.jct", "Candidates compare CSD.jct", "Check CSD.jct", "Runtime cold start compare.jct", "Runtime CPSM.jct", "Runtime CSD.jct", "Runtime compare.jct"};
    private static String jcl1 = "//";
    private static String comment1 = "//*";
    private static String comment2 = "//*----------------------------------";
    private static String parameters = "//CCVPARMS";

    public static Collection<IProject> getDAProjects() {
        debug.enter("getDAProjects");
        HashSet<IProject> projects = new HashSet<IProject>();
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IResource[] iResourceArray = root.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IProject && ((IProject)resource).isOpen()) {
                    IProjectDescription description = ((IProject)resource).getDescription();
                    String[] natures = description.getNatureIds();
                    int i = 0;
                    while (i < natures.length) {
                        if ("com.ibm.cics.zos.ui.nature".equals(natures[i])) {
                            projects.add((IProject)resource);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            debug.error("getDAProjects", (Throwable)e);
        }
        debug.exit("getDAProjects", projects);
        return projects;
    }

    public static void initialise(IProject project) throws CoreException, IOException {
        debug.enter("initialise");
        IFolder folder = project.getFolder(ZOSJCLMessages.Folder_template);
        try {
            if (!folder.exists()) {
                ResourceAttributes attributes;
                folder.create(true, true, null);
                String[] stringArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    IFile file = folder.getFile((IPath)new Path(element));
                    InputStream stream = ProjectManager.class.getResourceAsStream("/templates/" + element);
                    if (stream != null) {
                        if (file.exists()) {
                            file.setContents(stream, true, true, null);
                        } else {
                            file.create(stream, true, null);
                        }
                        stream.close();
                    }
                    if ((attributes = file.getResourceAttributes()) != null) {
                        attributes.setReadOnly(true);
                        file.setResourceAttributes(attributes);
                    }
                    ++n2;
                }
                attributes = folder.getResourceAttributes();
                if (attributes != null) {
                    attributes.setReadOnly(true);
                    folder.setResourceAttributes(attributes);
                }
            } else {
                ResourceAttributes attributes;
                folder.refreshLocal(1, null);
                IFile oldColdStartFile = folder.getFile(oldcold1);
                IFile newColdStartFile = folder.getFile(cold1);
                if (oldColdStartFile.exists() && !newColdStartFile.exists()) {
                    attributes = folder.getResourceAttributes();
                    attributes.setReadOnly(false);
                    folder.setResourceAttributes(attributes);
                    attributes = oldColdStartFile.getResourceAttributes();
                    attributes.setReadOnly(false);
                    oldColdStartFile.setResourceAttributes(attributes);
                    oldColdStartFile.move((IPath)new Path(cold1), true, null);
                    if (newColdStartFile.exists()) {
                        attributes = newColdStartFile.getResourceAttributes();
                        attributes.setReadOnly(true);
                        newColdStartFile.setResourceAttributes(attributes);
                    }
                    attributes = folder.getResourceAttributes();
                    attributes.setReadOnly(true);
                    folder.setResourceAttributes(attributes);
                }
                IFile oldCanCompFile = folder.getFile(oldCanComp);
                IFile canCompCPSMFile = folder.getFile(canCompCPSM);
                IFile canCompCSDFile = folder.getFile(canCompCSD);
                if (oldCanCompFile.exists()) {
                    InputStream stream;
                    attributes = folder.getResourceAttributes();
                    attributes.setReadOnly(false);
                    folder.setResourceAttributes(attributes);
                    attributes = oldCanCompFile.getResourceAttributes();
                    attributes.setReadOnly(false);
                    oldCanCompFile.setResourceAttributes(attributes);
                    oldCanCompFile.delete(true, null);
                    if (!canCompCPSMFile.exists()) {
                        stream = ProjectManager.class.getResourceAsStream("/templates/Candidates compare CPSM.jct");
                        if (stream != null) {
                            canCompCPSMFile.create(stream, true, null);
                            stream.close();
                        }
                        if ((attributes = canCompCPSMFile.getResourceAttributes()) != null) {
                            attributes.setReadOnly(true);
                            canCompCPSMFile.setResourceAttributes(attributes);
                        }
                    }
                    if (!canCompCSDFile.exists()) {
                        stream = ProjectManager.class.getResourceAsStream("/templates/Candidates compare CSD.jct");
                        if (stream != null) {
                            canCompCSDFile.create(stream, true, null);
                            stream.close();
                        }
                        if ((attributes = canCompCSDFile.getResourceAttributes()) != null) {
                            attributes.setReadOnly(true);
                            canCompCSDFile.setResourceAttributes(attributes);
                        }
                    }
                    attributes = folder.getResourceAttributes();
                    attributes.setReadOnly(true);
                    folder.setResourceAttributes(attributes);
                }
            }
            if (!(folder = project.getFolder(ZOSJCLMessages.User_defined)).exists()) {
                folder.create(true, true, null);
            }
        }
        catch (CoreException re) {
            debug.error("initialise", (Throwable)re);
        }
        debug.exit("initialise");
    }

    public static IProject getCurrentProject() {
        String projectRef = Platform.getPreferencesService().getString(UIActivator.getDefault().getBundle().getSymbolicName(), "PROJECT", Messages.getString("NewProject_project_name"), null);
        IProject currentproject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectRef);
        if (currentproject.isAccessible()) {
            try {
                if (currentproject.getNature("com.ibm.cics.zos.ui.nature") == null) {
                    ProjectManager.setNature(currentproject);
                }
            }
            catch (CoreException e) {
                debug.error("getCurrentProject", (Throwable)e);
            }
        } else if (currentproject.exists() && !currentproject.isOpen()) {
            try {
                currentproject.open(null);
            }
            catch (CoreException e) {
                debug.error("getCurrentProject", (Throwable)e);
                currentproject = null;
            }
        } else {
            currentproject = null;
        }
        return currentproject;
    }

    private static IFolder getWriteToFolder() {
        IFolder folder = null;
        IProject project = ProjectManager.getCurrentProject();
        if (project != null && !(folder = project.getFolder(ZOSJCLMessages.User_defined)).exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return folder;
    }

    public static StringBuffer getTemplate(String commandId, ISelection selection) {
        StringBuffer result = null;
        IProject project = ProjectManager.getCurrentProject();
        if (project != null) {
            IFile file;
            IFolder folder = project.getFolder(ZOSJCLMessages.Folder_template);
            if (!folder.exists()) {
                try {
                    ProjectManager.initialise(project);
                    folder = project.getFolder(ZOSJCLMessages.Folder_template);
                }
                catch (CoreException e) {
                    debug.error("getTemplate", (Throwable)e);
                }
                catch (IOException e) {
                    debug.error("getTemplate", (Throwable)e);
                }
            }
            if (folder.exists() && (file = folder.getFile(commandId)).exists()) {
                result = JCLUtilities.readFile((IFile)file);
                if (!commandId.equals(overall)) {
                    result = ProjectManager.substitutetext(result, commandId, selection);
                }
            }
        }
        return result;
    }

    private static StringBuffer substitutetext(StringBuffer template, String commandId, ISelection selection) {
        int parameters_start;
        boolean abort = false;
        String card1 = Platform.getPreferencesService().getString(UIActivator.getDefault().getBundle().getSymbolicName(), "JOB_CARD", "", null);
        StringBuffer card = new StringBuffer(card1);
        int comment_start = template.indexOf(comment2);
        int comment_end = template.indexOf(comment2, comment_start + comment2.length());
        if (comment_start > -1 && comment_end > comment_start) {
            int nextLine = template.indexOf(jcl1, comment_end + comment2.length());
            char[] buffer = new char[nextLine - comment_start - 1];
            template.getChars(comment_start, nextLine - 1, buffer, 0);
            comment_start = card.indexOf(comment1);
            comment_end = card.indexOf(comment2, comment_start + comment1.length());
            if (comment_start > -1 && comment_end > comment_start && (nextLine = card.indexOf(jcl1, comment_end + comment2.length())) > comment_start) {
                card.delete(comment_start, nextLine - 1);
                card.insert(comment_start, buffer);
            }
        } else {
            abort = true;
        }
        if ((parameters_start = template.indexOf(parameters)) > -1 && !abort) {
            int parameters_end = template.indexOf("*", parameters_start);
            if (parameters_end > parameters_start) {
                template.delete(0, ++parameters_end);
                template.insert(0, card);
            } else {
                abort = true;
            }
        } else {
            abort = true;
        }
        if (!abort) {
            int index = card.length();
            StringBuffer row = ProjectManager.getConnectionRow();
            template.insert(card.length(), row);
            int deploy = template.indexOf("DEPLOY", index += row.length());
            if (deploy > index) {
                template.delete(index, deploy - 4);
            } else {
                abort = true;
            }
        }
        if (!abort) {
            HashMap<String, String> mapping = new HashMap<String, String>();
            String filter = Platform.getPreferencesService().getString(UIActivator.getDefault().getBundle().getSymbolicName(), "FILTER", "", null);
            mapping.put("<file of filter statements>", String.valueOf(filter) + "\n/*");
            if (selection instanceof StructuredSelection) {
                Object[] objectArray = ((StructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof CSDConfiguration) {
                        mapping.put(substitute_CSDConfiguration, ((CSDConfiguration)element).getName());
                    } else if (element instanceof CPSMConfiguration) {
                        mapping.put(substitute_CPSMConfiguration, ((CPSMConfiguration)element).getName());
                        if (commandId.equals(oldCanComp)) {
                            mapping.put(substitute_CSDConfiguration, ((CPSMConfiguration)element).getName());
                        }
                    } else if (element instanceof IManagedRegion) {
                        mapping.put("<CICS region to be used as scope>", ((IManagedRegion)element).getName());
                    } else if (element instanceof IRegion) {
                        mapping.put("<CICS region to be used as scope>", ((IRegion)element).getName());
                    }
                    ++n2;
                }
                for (String key : mapping.keySet()) {
                    int start = template.indexOf(key);
                    if (start <= -1) continue;
                    template.delete(start, start + key.length());
                    template.insert(start, (String)mapping.get(key));
                }
            }
        }
        return template;
    }

    private static void setNature(IProject project) {
        debug.enter("setNature");
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("com.ibm.cics.zos.ui.nature".equals(natures[i])) {
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "com.ibm.cics.zos.ui.nature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            debug.error("setNature", (Throwable)e);
        }
        debug.exit("setNature");
    }

    private static StringBuffer getConnectionRow() {
        IConnectable connectable;
        StringBuffer row = new StringBuffer("    CONNECT    IPADDRESS=");
        IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        if (connectionService != null && (connectable = connectionService.getConnectable("com.ibm.cics.sm.connection")) != null && connectable.getConnection() != null) {
            ConnectionConfiguration configuration = connectable.getConnection().getConfiguration();
            if (connectable.getConnection() instanceof CMSMConnection && configuration != null) {
                row.append(configuration.getHost().toUpperCase());
                row.append(",PORT=");
                row.append(Integer.valueOf(configuration.getPort()).toString());
                row.append(",SSL=" + (configuration.getSecureHint() ? "YES" : "NO"));
                row.append("\n");
                return row;
            }
        }
        row.append("<HOSTNAME OR IP ADDRESS>,PORT=<CMPRT>,SSL=<YES or NO>\n");
        return row;
    }

    public static IFile getNewFileName(String oldid, String mainElement) {
        IFile myFile = null;
        int counter = 0;
        String id = oldid;
        IFolder folder = ProjectManager.getWriteToFolder();
        if (folder != null) {
            while (myFile == null || myFile.exists()) {
                int index = oldid.indexOf("jct");
                if (index > 0) {
                    id = counter == 0 ? (StringUtil.hasContent((String)mainElement) ? String.valueOf(oldid.substring(0, index - 1)) + '_' + mainElement + '.' + "jcl" : String.valueOf(oldid.substring(0, index - 1)) + '.' + "jcl") : (StringUtil.hasContent((String)mainElement) ? String.valueOf(oldid.substring(0, index - 1)) + '_' + mainElement + '_' + counter + '.' + "jcl" : String.valueOf(oldid.substring(0, index - 1)) + '_' + counter + '.' + "jcl");
                } else {
                    index = oldid.indexOf("jcl");
                    if (index > 0) {
                        id = counter == 0 ? (StringUtil.hasContent((String)mainElement) ? String.valueOf(oldid.substring(0, index - 1)) + '_' + mainElement + '.' + "jcl" : String.valueOf(oldid.substring(0, index - 1)) + '.' + "jcl") : (StringUtil.hasContent((String)mainElement) ? String.valueOf(oldid.substring(0, index - 1)) + '_' + mainElement + '_' + counter + '.' + "jcl" : String.valueOf(oldid.substring(0, index - 1)) + '_' + counter + '.' + "jcl");
                    }
                }
                myFile = folder.getFile(id);
                ++counter;
            }
        }
        return myFile;
    }

    public static IFile getNewDAReportFileName(String baseName) {
        IProject project = ProjectManager.getCurrentProject();
        IFolder folder = null;
        Date dateTime = new Date();
        String formatted = new SimpleDateFormat("yyyyMMddHHmm").format(dateTime);
        String fileName = String.valueOf(baseName) + '_' + formatted;
        if (project != null && !(folder = project.getFolder(Messages.getString("ProjectManager.folder.reportResults"))).exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        IFile myFile = null;
        int counter = 0;
        if (folder != null) {
            while (myFile == null || myFile.exists()) {
                fileName = String.valueOf(fileName) + (counter == 0 ? "" : Integer.valueOf(95 + counter)) + '.' + "dar";
                myFile = folder.getFile(fileName);
                ++counter;
            }
        }
        return myFile;
    }
}

