/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.CPSMParms;
import com.ibm.cics.cm.model.runtime.CSDParms;
import com.ibm.cics.cm.model.runtime.Element;
import com.ibm.cics.cm.model.runtime.Node;
import com.ibm.cics.cm.model.runtime.TagElement;
import java.util.ArrayList;
import java.util.List;

public class ProcessParms
extends Node {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<Node> children = new ArrayList<Node>();

    public static ProcessParms getOrphanedResourcesReportSet() {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("REPORTSET", "CPSMORPHANS");
        return processParms;
    }

    @Override
    public String getName() {
        return "PROCESSPARMS";
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public static ProcessParms getInstallForCPSM(String force, String scope) {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("FORCE", force);
        CPSMParms cPSMParms = CPSMParms.newCPSMParmsForInstall(scope);
        processParms.addChild(cPSMParms);
        return processParms;
    }

    public static ProcessParms getInstallForCSD(String quiesce, String discard, String[] connectionNames) {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("DISCARD", discard);
        processParms.addChild("QUIESCE", quiesce);
        CSDParms cSDParms = CSDParms.newCSDParmsConnectionList(connectionNames);
        processParms.addChild(cSDParms);
        return processParms;
    }

    public static ProcessParms getDiscardForCSD(String quiesce, String[] connectionNames) {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("QUIESCE", quiesce);
        CSDParms cSDParms = CSDParms.newCSDParmsConnectionList(connectionNames);
        processParms.addChild(cSDParms);
        return processParms;
    }

    public static ProcessParms getAdd() {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("REPLACE", "no");
        return processParms;
    }

    private void addChild(Node node) {
        this.children.add(node);
    }

    private void addChild(String attributeName, String value) {
        this.children.add(new TagElement(attributeName, value));
    }

    @Override
    public Element createElement(Element parentElement) {
        Element element = parentElement.createChild(this.getName());
        for (Node node : this.children) {
            node.createElement(element);
        }
        return element;
    }

    public String toString() {
        return "ProcessParms" + this.children.toString();
    }

    public static ProcessParms getSharedResourcesReportSet() {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("REPORTSET", "CPSMSHARED");
        return processParms;
    }

    public static ProcessParms getDuplicateResourcesByNameAndTypeReportSet() {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("REPORTSET", "DUPLICATENAMES");
        return processParms;
    }

    public static ProcessParms getUniqueNamesReportSet() {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("REPORTSET", "UNIQUENAMES");
        return processParms;
    }

    public static ProcessParms getChecksum(String checksumType) {
        ProcessParms processParms = new ProcessParms();
        if (checksumType.compareTo("NONE") != 0) {
            processParms.addChild("HASHINGSCOPE", checksumType);
        }
        return processParms;
    }

    public static ProcessParms getLimitResults(String value) {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("LIMITRESULTS", value);
        return processParms;
    }

    public static ProcessParms getExtendedServerInfo(boolean input) {
        String value = ProcessParms.getInput(input);
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("CONNECTIONDATA", value);
        return processParms;
    }

    public static ProcessParms getDisplayLimit(String value) {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("LIMIT", value);
        return processParms;
    }

    private static String getInput(boolean input) {
        String value = "NO";
        if (input) {
            value = "YES";
        }
        return value;
    }

    public static ProcessParms getReplace(boolean input) {
        ProcessParms processParms = new ProcessParms();
        processParms.addChild("REPLACE", ProcessParms.getInput(input));
        return processParms;
    }
}

