/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.runtime.Element;
import com.ibm.cics.cm.model.runtime.Node;
import java.util.Map;

public class ListElement
extends Node {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String subElementName;

    public ListElement(String group, String type, String name) {
        if (group != null) {
            this.attributes.put("OBJGROUP", group);
        }
        this.attributes.put("OBJTYPE", type);
        this.attributes.put("OBJNAME", name);
    }

    @Override
    public String getName() {
        return "LISTELEMENT";
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public Element createElement(Element parentElement) {
        Element element = parentElement.createChild(this.getName());
        Element subElement = null;
        Element attributesParent = element;
        if (this.subElementName != null) {
            attributesParent = subElement = element.createChild(this.subElementName);
        }
        for (Map.Entry<String, String> nodeTag : this.getElements()) {
            if (nodeTag.getValue() == null) continue;
            attributesParent.createChild(nodeTag.getKey(), CMUtilities.encodeToEBCDICValue(nodeTag.getValue()));
        }
        return element;
    }

    public String getSubElementName() {
        return this.subElementName;
    }

    public void setSubElementName(String subElementName) {
        this.subElementName = subElementName;
    }
}

